/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSObjectReferences;
import com.oracle.truffle.polyglot.enterprise.NativeObjectReferences;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import java.lang.ref.WeakReference;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;

final class HSContext
implements PolyglotIsolate.TearDownHook {
    final long contextId;
    final JNI.JWeak guestToHostReceiver;
    final long hostStackSpaceHeadroom;
    final JNICalls.JNIMethod guestToHostMessageDispatch;
    final HSObjectReferences hostToGuestObjectReferences;
    private final JNICalls.JNIMethod guestToHostReleaseReference;
    private final WeakReference<Object> polyglotContextReceiverReference;
    private boolean disposed;

    HSContext(JNI.JNIEnv jNIEnv, long l2, Object object, JNI.JObject jObject, long l3) {
        this.contextId = l2;
        this.polyglotContextReceiverReference = new WeakReference<Object>(object);
        this.hostStackSpaceHeadroom = l3;
        this.hostToGuestObjectReferences = new HSObjectReferences();
        this.guestToHostReceiver = JNIUtil.NewWeakGlobalRef(jNIEnv, jObject, NativeObjectReferences.class.getSimpleName());
        JNI.JClass jClass = jNIEnv.getFunctions().getGetObjectClass().call(jNIEnv, this.guestToHostReceiver);
        this.guestToHostMessageDispatch = JNICalls.JNIMethod.findMethod(jNIEnv, jClass, false, "messageDispatch", "(JI[B)[B");
        this.guestToHostReleaseReference = JNICalls.JNIMethod.findMethod(jNIEnv, jClass, false, "releaseReference", "(J)V");
        PolyglotIsolate.registerTearDownHook(20, this);
    }

    synchronized void dispose(JNI.JNIEnv jNIEnv) {
        if (!this.disposed) {
            this.disposed = true;
            JNIUtil.DeleteWeakGlobalRef(jNIEnv, this.guestToHostReceiver);
            this.hostToGuestObjectReferences.releaseAllReferences();
        }
    }

    synchronized void releaseGuestToHostReference(long l2) {
        JNI.JNIEnv jNIEnv;
        JNI.JObject jObject;
        if (!this.disposed && (jObject = JNIUtil.NewLocalRef(jNIEnv = JNIMethodScope.env(), this.guestToHostReceiver)).isNonNull()) {
            JNI.JValue jValue = StackValue.get(JNI.JValue.class);
            jValue.setLong(l2);
            ForeignException.getJNICalls().callVoid(jNIEnv, jObject, this.guestToHostReleaseReference, jValue);
        }
    }

    Object getPolyglotContextReceiverReference() {
        return this.polyglotContextReceiverReference.get();
    }

    @Override
    public void tearDown(JNI.JNIEnv jNIEnv) {
        this.dispose(jNIEnv);
    }
}

