/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSSourcePredicate;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.function.Predicate;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;

final class HSSourcePredicateGen {
    HSSourcePredicateGen() {
    }

    static HSSourcePredicate createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSSourcePredicate {
        private static final BinaryMarshaller<Object> objectWithSourceReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = objectWithSourceReceiverMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithSourceReceiverMarshaller.write((BinaryOutput)object2, object);
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(2, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.getHandle());
                    object2.addressOf(1).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.testMethod, (JNI.JValue)object2);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithSourceReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.SourceReceiver.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod testMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.testMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "test", "(Ljava/util/function/Predicate;[B)Z");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Object> objectWithSourceReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static boolean test(Predicate<Object> predicate, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithSourceReceiverMarshaller.read(binaryInput);
                boolean bl = predicate.test(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithSourceReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.SourceReceiver.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

