/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class RegexSource
implements JsonConvertible {
    private final String pattern;
    private final String flags;
    private final RegexOptions options;
    private final Source source;
    private boolean hashComputed = false;
    private int cachedHash;

    public RegexSource(String pattern, String flags, RegexOptions options, Source source) {
        this.pattern = pattern;
        this.flags = flags;
        this.options = options;
        this.source = source;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFlags() {
        return this.flags;
    }

    public RegexOptions getOptions() {
        return this.options;
    }

    public Encodings.Encoding getEncoding() {
        return this.options.getEncoding();
    }

    public Source getSource() {
        return this.source;
    }

    public RegexSource withBooleanMatch() {
        return new RegexSource(this.pattern, this.flags, this.options.withBooleanMatch(), this.source);
    }

    public RegexSource withoutBooleanMatch() {
        return new RegexSource(this.pattern, this.flags, this.options.withoutBooleanMatch(), this.source);
    }

    public int hashCode() {
        if (!this.hashComputed) {
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + this.pattern.hashCode();
            hash = 31 * hash + this.flags.hashCode();
            this.cachedHash = hash = 31 * hash + this.options.hashCode();
            this.hashComputed = true;
        }
        return this.cachedHash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RegexSource && this.pattern.equals(((RegexSource)obj).pattern) && this.flags.equals(((RegexSource)obj).flags) && this.options.equals(((RegexSource)obj).options);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "/" + this.pattern + "/" + this.flags;
    }

    @CompilerDirectives.TruffleBoundary
    public String toStringEscaped() {
        return DebugUtil.regexSourceEscape(this.pattern, this.flags);
    }

    @CompilerDirectives.TruffleBoundary
    public String toFileName() {
        StringBuilder sb = new StringBuilder(20);
        int i2 = 0;
        while (i2 < Math.min(this.pattern.length(), 20)) {
            int c2 = this.pattern.codePointAt(i2);
            if (DebugUtil.isValidCharForFileName(c2)) {
                sb.appendCodePoint(c2);
            } else {
                sb.append('_');
            }
            if (c2 > 65535) {
                i2 += 2;
                continue;
            }
            ++i2;
        }
        if (!this.flags.isEmpty()) {
            sb.append('_').append(this.flags);
        }
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("pattern", this.pattern), Json.prop("flags", this.flags));
    }
}

