/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.runtime.CompilationTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class TraversingBlockingQueue
implements BlockingQueue<Runnable> {
    final BlockingQueue<Runnable> entries;

    TraversingBlockingQueue(BlockingQueue<Runnable> entries) {
        this.entries = entries;
    }

    private static CompilationTask task(Runnable entry) {
        return ((CompilationTask.ExecutorServiceWrapper)entry).getCompileTask();
    }

    @Override
    public boolean add(Runnable e2) {
        return this.entries.add(e2);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        Runnable max = this.takeMax();
        if (max != null) {
            return max;
        }
        return this.entries.poll(timeout, unit);
    }

    @Override
    public Runnable poll() {
        Runnable max = this.takeMax();
        if (max != null) {
            return max;
        }
        return (Runnable)this.entries.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Runnable takeMax() {
        CompilationTask task;
        if (this.entries.isEmpty()) {
            return null;
        }
        Runnable max = null;
        long time = System.nanoTime();
        int removed = 0;
        try {
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                Runnable entry = (Runnable)it.next();
                task = TraversingBlockingQueue.task(entry);
                if (task.isCancelled() || !task.updateWeight(time)) {
                    it.remove();
                    --removed;
                    continue;
                }
                if (max != null && !task.isHigherPriorityThan(TraversingBlockingQueue.task(max))) continue;
                max = entry;
            }
            Runnable runnable = this.entries.remove(max) ? max : null;
            return runnable;
        }
        finally {
            if (max != null) {
                task = TraversingBlockingQueue.task(max);
                task.setTime(System.nanoTime() - time);
                task.setQueueChange(removed - 1);
            }
        }
    }

    @Override
    public boolean offer(Runnable e2) {
        return this.entries.offer(e2);
    }

    @Override
    public Runnable remove() {
        return (Runnable)this.entries.remove();
    }

    @Override
    public Runnable element() {
        return (Runnable)this.entries.element();
    }

    @Override
    public Runnable peek() {
        return (Runnable)this.entries.peek();
    }

    @Override
    public void put(Runnable e2) throws InterruptedException {
        this.entries.put(e2);
    }

    @Override
    public boolean offer(Runnable e2, long timeout, TimeUnit unit) throws InterruptedException {
        return this.entries.offer(e2, timeout, unit);
    }

    @Override
    public Runnable take() throws InterruptedException {
        Runnable max = this.takeMax();
        if (max != null) {
            return max;
        }
        return this.entries.take();
    }

    @Override
    public int remainingCapacity() {
        return this.entries.remainingCapacity();
    }

    @Override
    public boolean remove(Object o2) {
        return this.entries.remove(o2);
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.entries.containsAll(c2);
    }

    @Override
    public boolean addAll(Collection<? extends Runnable> c2) {
        return this.entries.addAll(c2);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        return this.entries.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        return this.entries.retainAll(c2);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean contains(Object o2) {
        return this.entries.contains(o2);
    }

    @Override
    public Iterator<Runnable> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.entries.toArray(a2);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c2) {
        return this.entries.drainTo(c2);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c2, int maxElements) {
        return this.entries.drainTo(c2, maxElements);
    }
}

