/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client;

import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveMCClientRegistration;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.CommonConstants;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.datafixers.util.Pair;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientUtil {
    public static final int maxLight = LightTexture.pack((int)15, (int)15);
    public static int immersiveLeftClickCooldown = 0;

    public static RegistryAccess getRegistryAccess() {
        return Minecraft.getInstance().level.registryAccess();
    }

    public static Vec3 lerpVec3(Vec3 start, Vec3 end, float partialTick) {
        return new Vec3(Mth.lerp((double)partialTick, (double)start.x, (double)end.x), Mth.lerp((double)partialTick, (double)start.y, (double)end.y), Mth.lerp((double)partialTick, (double)start.z, (double)end.z));
    }

    public static Pair<Vec3, Vec3> getVRStartAndEnd(int device) {
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player);
        IVRData vrData = device == -1 ? vrPlayer.getHMD() : vrPlayer.getController(device);
        double dist = Minecraft.getInstance().player.blockInteractionRange();
        Vec3 start = vrData.position();
        Vec3 look = vrData.getLookAngle();
        Vec3 end = vrData.position().add(look.x * dist, look.y * dist, look.z * dist);
        return new Pair((Object)start, (Object)end);
    }

    public static void clearDisabledImmersives() {
        for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> immersive : Immersives.IMMERSIVES) {
            if (immersive.getHandler().enabledInConfig((Player)Minecraft.getInstance().player)) continue;
            immersive.getTrackedObjects().clear();
        }
        for (AbstractPlayerAttachmentImmersive abstractPlayerAttachmentImmersive : Immersives.IMMERSIVE_ATTACHMENTS) {
            if (abstractPlayerAttachmentImmersive.enabledInConfig()) continue;
            abstractPlayerAttachmentImmersive.clearImmersives();
        }
    }

    public static ImmersiveConfigScreenInfo createConfigScreenInfo(String keyName, Supplier<ItemStack> optionItem, Function<ActiveConfig, Boolean> configGetter, BiConsumer<ActiveConfig, Boolean> configSetter) {
        return ImmersiveMCClientRegistration.instance().createConfigScreenInfoOneItem("immersivemc", "config.immersivemc." + keyName, optionItem, (Component)Component.translatable((String)("config.immersivemc." + keyName + ".desc")), () -> (Boolean)configGetter.apply(ConfigScreen.getAdjustingConfig()), newVal -> configSetter.accept(ConfigScreen.getAdjustingConfig(), (Boolean)newVal));
    }

    public static Vec3 playerPos() {
        return Minecraft.getInstance().player.getPosition(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
    }

    public static Tuple<Vec3, Vec3> getStartAndEndOfLookTrace(Player player) {
        BlockHitResult bhr;
        Vec3 viewVec;
        Vec3 start;
        double dist = Minecraft.getInstance().player.blockInteractionRange();
        if (VRPluginVerify.clientInVR()) {
            start = VRPlugin.API.getVRPlayer(player).getController0().position();
            viewVec = VRPlugin.API.getVRPlayer(player).getController0().getLookAngle();
        } else {
            start = player.getEyePosition(1.0f);
            viewVec = player.getViewVector(1.0f);
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult && (bhr = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK) {
            dist = bhr.getLocation().distanceTo(start);
        }
        Vec3 end = start.add(viewVec.x * dist, viewVec.y * dist, viewVec.z * dist);
        return new Tuple((Object)start, (Object)end);
    }

    public static Direction getClosestDirection(Vec3 velocity) {
        double max = Math.max(Math.abs(velocity.x), Math.max(Math.abs(velocity.y), Math.abs(velocity.z)));
        if (max == Math.abs(velocity.x)) {
            return velocity.x < 0.0 ? Direction.WEST : Direction.EAST;
        }
        if (max == Math.abs(velocity.y)) {
            return velocity.y < 0.0 ? Direction.DOWN : Direction.UP;
        }
        return velocity.z < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public static void openBag(Player player) {
        if (VRPluginVerify.hasAPI) {
            if (VRPlugin.API.playerInVR(player)) {
                if (VRPlugin.API.apiActive(player)) {
                    Immersives.immersiveBackpack.doTrack();
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.immersivemc.no_api_server"));
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"message.immersivemc.not_in_vr"));
            }
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"message.immersivemc.no_api", (Object[])new Object[]{CommonConstants.vrAPIVersionAsString(), CommonConstants.firstNonCompatibleFutureVersionAsString()}));
        }
    }

    @Nullable
    public static <I extends ImmersiveInfo> I findImmersive(Immersive<I, ?> immersive, BlockPos pos) {
        for (ImmersiveInfo info : immersive.getTrackedObjects()) {
            if (!Util.getValidBlocks(immersive.getHandler(), info.getBlockPosition(), (Level)Minecraft.getInstance().level).contains(pos)) continue;
            return (I)info;
        }
        return null;
    }
}

