/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.api_impl;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.immersive.SwapTracker;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.obb.OBBRotList;
import com.hammy275.immersivemc.common.obb.RotType;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveRenderHelpersImpl
implements ImmersiveRenderHelpers {
    public static final ImmersiveRenderHelpers INSTANCE = new ImmersiveRenderHelpersImpl();

    @Override
    public void renderItemWithInfo(ItemStack item, PoseStack stack, float size, boolean renderItemCounts, int light, ImmersiveInfo info, boolean shouldRenderItemGuide, int hitboxIndex, @Nullable Float spinDegrees, @Nullable Direction facing, @Nullable Direction upDown) {
        boolean hovered;
        HitboxInfo hitbox = info.getAllHitboxes().get(hitboxIndex);
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        boolean bl = hovered = info.getSlotHovered(0) == hitboxIndex || info.getSlotHovered(1) == hitboxIndex || SwapTracker.slotHovered(info, hitboxIndex);
        if (item == null || item.isEmpty()) {
            if (shouldRenderItemGuide) {
                this.renderItemGuide(stack, hitbox.getRenderHitbox(partialTick), hovered, light);
            }
        } else {
            long ticksExisted = info.getTicksExisted();
            size = ticksExisted < 10L ? (size *= this.getTransitionMultiplier(info.getTicksExisted())) : (hovered ? size * 1.25f : size);
            BoundingBox bbox = hitbox.getRenderHitbox(partialTick);
            this.renderItem(item, stack, size, bbox, renderItemCounts, light, spinDegrees, facing, upDown);
        }
    }

    @Override
    public void renderItem(ItemStack item, PoseStack stack, float size, BoundingBox hitbox, boolean renderItemCounts, int light) {
        this.renderItem(item, stack, size, hitbox, renderItemCounts, light, null, null, null);
    }

    @Override
    public void renderItem(ItemStack item, PoseStack stack, float size, BoundingBox hitbox, boolean renderItemCounts, int light, @Nullable Float spinDegrees, @Nullable Direction facing, @Nullable Direction upDown) {
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 pos = BoundingBox.getCenter(hitbox);
        if (item != null && item != ItemStack.EMPTY) {
            stack.pushPose();
            stack.translate(-renderInfo.getPosition().x + pos.x, -renderInfo.getPosition().y + pos.y, -renderInfo.getPosition().z + pos.z);
            stack.scale(size, size, size);
            Vec3 textPos = pos;
            float degreesRotation = 0.0f;
            if (spinDegrees != null) {
                degreesRotation = spinDegrees.floatValue();
            } else if (facing == Direction.WEST) {
                degreesRotation = 90.0f;
            } else if (facing == Direction.SOUTH) {
                degreesRotation = 180.0f;
            } else if (facing == Direction.EAST) {
                degreesRotation = 270.0f;
            }
            int upDownRot = 0;
            if (upDown == Direction.UP) {
                upDownRot = 90;
                textPos = textPos.add(0.0, 0.15, 0.0);
            } else if (upDown == Direction.DOWN) {
                upDownRot = 270;
                textPos = textPos.add(0.0, -0.15, 0.0);
            } else if (facing == Direction.WEST) {
                textPos = textPos.add(-0.15, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                textPos = textPos.add(0.0, 0.0, 0.15);
            } else if (facing == Direction.EAST) {
                textPos = textPos.add(0.15, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                textPos = textPos.add(0.0, 0.0, -0.15);
            } else if (facing == null) {
                Vec3 textMove;
                this.faceTowardsPlayer(stack, BoundingBox.getCenter(hitbox));
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                if (VRPluginVerify.hasAPI && VRPluginVerify.clientInVR()) {
                    IVRPlayer textMovePlayer = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player) : VRPlugin.API.getRenderVRPlayer();
                    textMove = textMovePlayer.getHMD().getLookAngle();
                } else {
                    textMove = Minecraft.getInstance().player.getLookAngle();
                }
                textMove = textMove.multiply(-0.05, -0.05, -0.05);
                textPos = textPos.add(textMove);
            }
            if (facing != null) {
                stack.mulPose(Axis.YP.rotationDegrees(degreesRotation));
                stack.mulPose(Axis.XP.rotationDegrees((float)upDownRot));
            }
            ItemDisplayContext type = facing == null ? ItemDisplayContext.GROUND : ItemDisplayContext.FIXED;
            Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)Minecraft.getInstance().player, item, type, false, stack, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), (Level)Minecraft.getInstance().level, light, OverlayTexture.NO_OVERLAY, 0);
            stack.popPose();
            if (renderItemCounts && item.getCount() > 1) {
                this.renderText((Component)Component.literal((String)String.valueOf(item.getCount())), stack, textPos, light, facing == null ? 0.0025f : 0.01f);
            }
        }
        this.renderHitbox(stack, hitbox);
    }

    @Override
    public void renderItemGuide(PoseStack stack, BoundingBox hitbox, boolean isSelected, int light) {
        ClientRenderSubscriber.itemGuideRenderData.add(new ClientRenderSubscriber.ItemGuideRenderData(stack, hitbox, 0.2f, isSelected, light));
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox) {
        this.renderHitbox(stack, hitbox, false);
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender) {
        this.renderHitbox(stack, hitbox, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue) {
        this.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, 1.0f);
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue, float alpha) {
        if ((Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes() || alwaysRender) && hitbox != null) {
            if (hitbox.isAABB()) {
                Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
                stack.pushPose();
                stack.translate(-renderInfo.getPosition().x, -renderInfo.getPosition().y, -renderInfo.getPosition().z);
                MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)buffer.getBuffer((RenderType)RenderType.LINES), (AABB)hitbox.asAABB(), (float)red, (float)green, (float)blue, (float)alpha);
                stack.popPose();
            } else {
                OBBClientUtil.renderOBB(stack, hitbox.asOBB(), alwaysRender, red, green, blue, alpha);
            }
        }
    }

    @Override
    public void renderText(Component text, PoseStack stack, Vec3 pos, int light, float textSize) {
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        stack.pushPose();
        stack.translate(-renderInfo.getPosition().x + pos.x, -renderInfo.getPosition().y + pos.y, -renderInfo.getPosition().z + pos.z);
        stack.mulPose(renderInfo.rotation());
        stack.scale(textSize *= ActiveConfig.active().textScale, -textSize, textSize);
        Font font = Minecraft.getInstance().font;
        float size = (float)(-font.width((FormattedText)text)) / 2.0f;
        font.drawInBatch(text, size, 0.0f, -1, false, stack.last().pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, light);
        stack.popPose();
    }

    @Override
    public void renderImage(PoseStack stack, ResourceLocation imageLocation, Vec3 pos, float size, int light, @Nullable Direction facing) {
        this.renderImage(stack, imageLocation, 0.0f, 0.0f, 1.0f, 1.0f, pos, size, light, facing);
    }

    @Override
    public void renderImage(PoseStack stack, ResourceLocation imageLocation, float minImageU, float minImageV, float maxImageU, float maxImageV, Vec3 pos, float size, int light, @Nullable Direction facing) {
        this.renderImage(stack, imageLocation, minImageU, minImageV, maxImageU, maxImageV, pos, size, light, 0.0f, facing);
    }

    @Override
    public void renderImage(PoseStack stack, ResourceLocation imageLocation, float minImageU, float minImageV, float maxImageU, float maxImageV, Vec3 pos, float size, int light, float roll, @Nullable Direction facing) {
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        stack.pushPose();
        stack.translate(-renderInfo.getPosition().x + pos.x, -renderInfo.getPosition().y + pos.y, -renderInfo.getPosition().z + pos.z);
        stack.scale(size, size, size);
        if (facing == Direction.WEST) {
            stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else if (facing == Direction.SOUTH) {
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        } else if (facing == Direction.EAST) {
            stack.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (facing == null) {
            this.faceTowardsPlayer(stack, pos);
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        stack.mulPose(Axis.ZN.rotationDegrees(roll));
        VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)imageLocation));
        PoseStack.Pose pose = stack.last();
        consumer.addVertex(pose, -0.5f, -0.25f, 0.0f).setColor(-1).setUv(minImageU, maxImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.5f, -0.25f, 0.0f).setColor(-1).setUv(maxImageU, maxImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.5f, 0.75f, 0.0f).setColor(-1).setUv(maxImageU, minImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, -0.5f, 0.75f, 0.0f).setColor(-1).setUv(minImageU, minImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        stack.popPose();
    }

    @Override
    public float getTransitionMultiplier(long ticksExisted) {
        return Math.min(1.0f, 0.1f * ((float)ticksExisted + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true)));
    }

    @Override
    public float hoverScaleSizeMultiplier() {
        return 1.25f;
    }

    private void faceTowardsPlayer(PoseStack stack, Vec3 renderPos) {
        if (VRPluginVerify.clientInVR()) {
            Vec3 target = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player).getHMD().position() : VRPlugin.API.getRenderVRPlayer().getHMD().position();
            Vec3 ray = target.subtract(renderPos);
            Vec3 rayNoY = ray.multiply(1.0, 0.0, 1.0);
            OBBRotList rotList = OBBRotList.create().addRot(Math.atan2(ray.z, ray.x) + 1.5707963267948966, RotType.YAW).addRot(-Math.atan2(ray.y, rayNoY.length()), RotType.PITCH);
            stack.mulPose(rotList.asQuaternion());
        } else {
            stack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        }
    }
}

