/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.immersive.ImmersiveBackpack;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.BackpackMode;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ReachBehindBackpackMode;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.time.Instant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BackpackConfigScreen
extends OptionsSubScreen {
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public BackpackConfigScreen(Screen lastScreen) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Component.translatable((String)"screen.immersivemc.backpack_config.title"));
    }

    protected void addOptions() {
        this.list.addBig(ScreenUtils.createEnumOption(BackpackMode.class, "config.immersivemc.backpack_mode", backpackMode -> Component.translatable((String)("config.immersivemc.backpack_mode." + backpackMode.ordinal())), backpackMode -> Component.translatable((String)("config.immersivemc.backpack_mode." + backpackMode.ordinal() + ".desc")), () -> ConfigScreen.getClientConfigIfAdjusting().bagMode, (newModeIndex, newMode) -> {
            BackpackMode oldMode = ConfigScreen.getClientConfigIfAdjusting().bagMode;
            ConfigScreen.getClientConfigIfAdjusting().bagMode = newMode;
            ActiveConfig.activeRaw().bagMode = newMode;
            if (oldMode.colorable != newMode.colorable) {
                Minecraft.getInstance().setScreen((Screen)new BackpackConfigScreen(this.lastScreen));
            }
        }));
        this.list.addBig(ScreenUtils.createEnumOption(ReachBehindBackpackMode.class, "config.immersivemc.reach_behind_backpack_mode", reachBehindBackpackMode -> Component.translatable((String)("config.immersivemc.reach_behind_backpack_mode." + reachBehindBackpackMode.ordinal())), reachBehindBackpackMode -> Component.translatable((String)("config.immersivemc.reach_behind_backpack_mode." + reachBehindBackpackMode.ordinal() + ".desc")), () -> ConfigScreen.getClientConfigIfAdjusting().reachBehindBagMode, (newModeIndex, newMode) -> {
            ConfigScreen.getClientConfigIfAdjusting().reachBehindBagMode = newMode;
        }));
        this.list.addBig(ScreenUtils.createOption("swap_bag_hand", config -> ((ClientActiveConfig)config).swapBagHand, (config, val) -> {
            ((ClientActiveConfig)config).swapBagHand = val;
        }));
        if (ConfigScreen.getClientConfigIfAdjusting().bagMode.colorable) {
            this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.backpack_r", integer -> Component.literal((String)(I18n.get((String)"config.immersivemc.backpack_r", (Object[])new Object[0]) + ": " + this.getRGB('r'))), 0, 255, () -> this.getRGB('r'), newRVal -> this.setRGB((Integer)newRVal, 'r')));
            this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.backpack_g", integer -> Component.literal((String)(I18n.get((String)"config.immersivemc.backpack_g", (Object[])new Object[0]) + ": " + this.getRGB('g'))), 0, 255, () -> this.getRGB('g'), newRVal -> this.setRGB((Integer)newRVal, 'g')));
            this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.backpack_b", integer -> Component.literal((String)(I18n.get((String)"config.immersivemc.backpack_b", (Object[])new Object[0]) + ": " + this.getRGB('b'))), 0, 255, () -> this.getRGB('b'), newRVal -> this.setRGB((Integer)newRVal, 'b')));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderBackpack(graphics.pose());
    }

    protected void renderBackpack(PoseStack stack) {
        stack.pushPose();
        int rgb = ImmersiveBackpack.getBackpackColor();
        float size = 72.0f;
        stack.translate((double)this.width * 0.9325, (double)((float)this.height / 2.0f), 548.0);
        stack.scale(0.5f, 0.5f, 0.5f);
        long currentTimeMilli = Instant.now().toEpochMilli();
        long millisPerRot = 8000L;
        float rot = (float)(currentTimeMilli % millisPerRot) / (float)millisPerRot * ((float)Math.PI * 2);
        stack.mulPose(Axis.XN.rotationDegrees(205.0f));
        stack.mulPose(Axis.YN.rotation(rot));
        stack.translate(0.0, (double)size * 1.75, 0.0);
        stack.scale(size, -size, size);
        ImmersiveBackpack.getBackpackModel().renderToBuffer(stack, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)ImmersiveBackpack.getBackpackTexture())), 0xF000F0, OverlayTexture.NO_OVERLAY, rgb);
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
        stack.popPose();
    }

    public void onClose() {
        ConfigScreen.writeAdjustingConfig();
        super.onClose();
    }

    protected int getRGB(char type) {
        if (type == 'r') {
            return ConfigScreen.getClientConfigIfAdjusting().bagColor >> 16;
        }
        if (type == 'g') {
            return ConfigScreen.getClientConfigIfAdjusting().bagColor >> 8 & 0xFF;
        }
        return ConfigScreen.getClientConfigIfAdjusting().bagColor & 0xFF;
    }

    protected void setRGB(Integer newVal, char type) {
        int newColor;
        Vec3i rgb = new Vec3i(this.getRGB('r'), this.getRGB('g'), this.getRGB('b'));
        rgb = type == 'r' ? new Vec3i(newVal.intValue(), rgb.getY(), rgb.getZ()) : (type == 'g' ? new Vec3i(rgb.getX(), newVal.intValue(), rgb.getZ()) : new Vec3i(rgb.getX(), rgb.getY(), newVal.intValue()));
        ConfigScreen.getClientConfigIfAdjusting().bagColor = newColor = (rgb.getX() << 16) + (rgb.getY() << 8) + rgb.getZ();
        ActiveConfig.activeRaw().bagColor = newColor;
    }
}

