/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.config.screen.BackpackConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ImmersivesConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ImmersivesCustomizeScreen;
import com.hammy275.immersivemc.client.config.screen.ItemGuideCustomizeScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ConfigType;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ConfigSyncPacket;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ConfigScreen
extends Screen {
    protected final Screen lastScreen;
    private static ConfigType currentConfigAdjusting = ConfigType.CLIENT;
    protected static int BUTTON_WIDTH = 200;
    protected static int BUTTON_HEIGHT = 20;
    protected static int BUTTON_SPACING = BUTTON_HEIGHT + BUTTON_HEIGHT / 5;
    protected static int BUTTON_START_HEIGHT = 24;
    protected static final String WIKI_URL = "https://hammy275.com/immersivemcwiki";

    public ConfigScreen(Screen screen) {
        super((Component)Component.translatable((String)"screen.immersivemc.config.title"));
        this.lastScreen = screen;
    }

    protected void init() {
        ActiveConfig.loadActive();
        super.init();
        if (currentConfigAdjusting == ConfigType.CLIENT) {
            this.addRenderableWidget((GuiEventListener)ScreenUtils.createScreenButton((this.width - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.customize_item_guides", (Screen)new ItemGuideCustomizeScreen(this)));
            this.addRenderableWidget((GuiEventListener)ScreenUtils.createScreenButton((this.width - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT + BUTTON_SPACING, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.backpack", (Screen)new BackpackConfigScreen(this)));
        }
        this.addRenderableWidget((GuiEventListener)ScreenUtils.createScreenButton((this.width - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT + BUTTON_SPACING * 2, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.immersives_customize", (Screen)new ImmersivesCustomizeScreen(this)));
        this.addRenderableWidget((GuiEventListener)ScreenUtils.createScreenButton((this.width - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT + BUTTON_SPACING * 3, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.immersives", (Screen)new ImmersivesConfigScreen(this, VRPluginVerify.clientInVR() || currentConfigAdjusting == ConfigType.SERVER ? ImmersivesConfigScreen.ScreenType.BOTH : ImmersivesConfigScreen.ScreenType.NONVR)));
        this.addRenderableWidget((GuiEventListener)ScreenUtils.createScreenButton((this.width - BUTTON_WIDTH) / 2 - BUTTON_WIDTH / 2 - 8, this.height - BUTTON_SPACING * 2, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.wiki_button", (Screen)new ConfirmLinkScreen(clickedYes -> {
            if (clickedYes) {
                Util.getPlatform().openUri(WIKI_URL);
            }
            Minecraft.getInstance().setScreen((Screen)this);
        }, (Component)Component.translatable((String)"config.immersivemc.open_wiki_message"), (Component)Component.empty(), WIKI_URL, CommonComponents.GUI_CANCEL, true)));
        this.addRenderableWidget((GuiEventListener)ScreenUtils.createDoneButton((this.width - BUTTON_WIDTH) / 2, this.height - BUTTON_SPACING, BUTTON_WIDTH, BUTTON_HEIGHT, this));
        this.addRenderableWidget((GuiEventListener)ScreenUtils.createButton((this.width - BUTTON_WIDTH) / 2 + BUTTON_WIDTH / 2 + 8, this.height - BUTTON_SPACING * 2, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.reset", button -> {
            if (currentConfigAdjusting == ConfigType.CLIENT) {
                ActiveConfig.FILE_CLIENT = new ClientActiveConfig();
            } else {
                ActiveConfig.FILE_SERVER = new ActiveConfig();
            }
            ActiveConfig.loadActive();
            button.active = false;
        }));
        String configTypeButtonTranslationKey = "config.immersivemc.edit_config_type.server";
        if (currentConfigAdjusting == ConfigType.CLIENT) {
            this.addRenderableWidget((GuiEventListener)ScreenUtils.createOption("disable_outside_vr", config -> ((ClientActiveConfig)config).disableImmersiveMCOutsideVR, (config, newVal) -> {
                ((ClientActiveConfig)config).disableImmersiveMCOutsideVR = newVal;
            }).createButton(Minecraft.getInstance().options, (this.width - BUTTON_WIDTH) / 2, this.height - BUTTON_SPACING * 4, BUTTON_WIDTH));
            configTypeButtonTranslationKey = "config.immersivemc.edit_config_type.client";
        }
        Button configTypeButton = ScreenUtils.createButton((this.width - BUTTON_WIDTH) / 2, this.height - BUTTON_SPACING * 3, BUTTON_WIDTH, BUTTON_HEIGHT, configTypeButtonTranslationKey, configTypeButtonTranslationKey + ".desc", button -> ConfigScreen.changeConfigAdjusting());
        configTypeButton.active = Minecraft.getInstance().player == null || Minecraft.getInstance().hasSingleplayerServer();
        this.addRenderableWidget((GuiEventListener)configTypeButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title.getString(), this.width / 2, 8, 0xFFFFFF);
    }

    public void onClose() {
        ConfigScreen.onClientConfigChange();
        Minecraft.getInstance().setScreen(this.lastScreen);
        currentConfigAdjusting = ConfigType.CLIENT;
    }

    public static void onClientConfigChange() {
        ConfigScreen.writeAdjustingConfig();
        for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> immersive : Immersives.IMMERSIVES) {
            immersive.getTrackedObjects().clear();
        }
        for (AbstractPlayerAttachmentImmersive abstractPlayerAttachmentImmersive : Immersives.IMMERSIVE_ATTACHMENTS) {
            abstractPlayerAttachmentImmersive.clearImmersives();
        }
        if (currentConfigAdjusting == ConfigType.SERVER) {
            if (Minecraft.getInstance().hasSingleplayerServer()) {
                ActiveConfig.FROM_SERVER = (ActiveConfig)ActiveConfig.FILE_SERVER.clone();
                ActiveConfig.loadActive();
                ActiveConfig.registerPlayerConfig((Player)Minecraft.getInstance().player, ActiveConfig.activeRaw());
                IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
                if (server != null && server.isPublished()) {
                    server.getPlayerList().getPlayers().stream().filter(player -> !player.getUUID().equals(Minecraft.getInstance().player.getUUID())).forEach(ConfigSyncPacket::syncConfigToPlayer);
                }
                TrackedImmersives.clearForPlayer(Minecraft.getInstance().getSingleplayerServer().getPlayerList().getPlayer(Minecraft.getInstance().player.getUUID()));
            }
        } else if (Minecraft.getInstance().level != null) {
            ActiveConfig.loadActive();
            Network.INSTANCE.sendToServer(new ConfigSyncPacket(ActiveConfig.FILE_CLIENT));
        }
    }

    private static void changeConfigAdjusting() {
        ConfigScreen.onClientConfigChange();
        currentConfigAdjusting = currentConfigAdjusting == ConfigType.CLIENT ? ConfigType.SERVER : ConfigType.CLIENT;
        Screen current = Minecraft.getInstance().screen;
        if (current instanceof ConfigScreen) {
            ConfigScreen cs = (ConfigScreen)current;
            Minecraft.getInstance().setScreen((Screen)new ConfigScreen(cs.lastScreen));
        }
    }

    public static ActiveConfig getAdjustingConfig() {
        return ActiveConfig.getFileConfig(currentConfigAdjusting);
    }

    public static ConfigType getAdjustingConfigType() {
        return currentConfigAdjusting;
    }

    public static ClientActiveConfig getClientConfigIfAdjusting() {
        if (currentConfigAdjusting == ConfigType.CLIENT) {
            return (ClientActiveConfig)ActiveConfig.getFileConfig(ConfigType.CLIENT);
        }
        throw new IllegalStateException("Not currently adjusting client config!");
    }

    public static boolean writeAdjustingConfig() {
        return ActiveConfig.getFileConfig(currentConfigAdjusting).writeConfigFile(currentConfigAdjusting);
    }
}

