/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.model.Cube1x1;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ItemGuideColorData;
import com.hammy275.immersivemc.common.config.ItemGuidePreset;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.util.RGBA;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemGuideCustomizeScreen
extends OptionsSubScreen {
    private static final String[] types = new String[]{"item_guide_custom", "item_guide_selected_custom", "ranged_grab_custom"};
    private static final char[] rgba = new char[]{'r', 'g', 'b', 'a'};
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public ItemGuideCustomizeScreen(Screen lastScreen) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Component.translatable((String)"screen.immersivemc.item_guide_customize_screen"));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ClientRenderSubscriber.setRenderColors();
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderPreview(graphics.pose(), ClientRenderSubscriber.itemGuideColor(), 0.25f, false, ConfigScreen.getClientConfigIfAdjusting().itemGuideSize);
        this.renderPreview(graphics.pose(), ClientRenderSubscriber.itemGuideSelectedColor(), 0.5f, false, ConfigScreen.getClientConfigIfAdjusting().itemGuideSelectedSize);
        this.renderPreview(graphics.pose(), ClientRenderSubscriber.rangedGrabColor(), 0.75f, true, 1.0);
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.width * 19 / 20 - 16, this.height * 250 / 1000 - 16, this.width * 19 / 20 + 16, this.height * 250 / 1000 + 16)) {
            graphics.renderTooltip(this.font, Tooltip.splitTooltip((Minecraft)Minecraft.getInstance(), (Component)Component.translatable((String)"config.immersivemc.item_guide.desc")), mouseX, mouseY);
        }
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.width * 19 / 20 - 16, this.height * 500 / 1000 - 16, this.width * 19 / 20 + 16, this.height * 500 / 1000 + 16)) {
            graphics.renderTooltip(this.font, Tooltip.splitTooltip((Minecraft)Minecraft.getInstance(), (Component)Component.translatable((String)"config.immersivemc.item_guide_selected.desc")), mouseX, mouseY);
        }
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.width * 19 / 20 - 16, this.height * 750 / 1000 - 16, this.width * 19 / 20 + 16, this.height * 750 / 1000 + 16)) {
            graphics.renderTooltip(this.font, Tooltip.splitTooltip((Minecraft)Minecraft.getInstance(), (Component)Component.translatable((String)"config.immersivemc.ranged_grab_color.desc")), mouseX, mouseY);
        }
    }

    private void renderPreview(PoseStack stack, RGBA color, float heightMult, boolean renderSquare, double size) {
        stack.pushPose();
        stack.translate((double)this.width * 0.95, (double)((float)this.height * heightMult - 16.0f), 0.0);
        stack.scale(0.225f, 0.225f, 0.225f);
        if (!renderSquare) {
            long currentTimeMilli = Instant.now().toEpochMilli();
            long millisPerRot = 8000L;
            float rot = (float)(currentTimeMilli % millisPerRot) / (float)millisPerRot * ((float)Math.PI * 2);
            stack.mulPose(Axis.YN.rotation(rot));
        }
        if (renderSquare) {
            stack.translate(0.0f, 64.0f * color.alphaF(), 0.0f);
            stack.scale(color.alphaF(), color.alphaF(), color.alphaF());
        } else {
            stack.translate(0.0, 64.0 * size, 0.0);
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        if (ConfigScreen.getClientConfigIfAdjusting().placementGuideMode == PlacementGuideMode.CUBE || renderSquare) {
            RGBA renderColor = renderSquare ? new RGBA(color.toLong() | 0xFF000000L) : color;
            ClientRenderSubscriber.cubeModel.render(stack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)Cube1x1.textureLocation)), (int)renderColor.toLong(), 64.0f * (float)size, ClientUtil.maxLight);
        } else if (ConfigScreen.getClientConfigIfAdjusting().placementGuideMode == PlacementGuideMode.OUTLINE) {
            LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)buffer.getBuffer((RenderType)RenderType.LINES), (AABB)AABB.ofSize((Vec3)Vec3.ZERO, (double)(128.0 * size), (double)(128.0 * size), (double)(128.0 * size)), (float)color.redF(), (float)color.greenF(), (float)color.blueF(), (float)color.alphaF());
        }
        buffer.endBatch();
        stack.popPose();
    }

    protected void addOptions() {
        this.list.addBig(ScreenUtils.createEnumOption(PlacementGuideMode.class, "config.immersivemc.placement_guide_mode", guideMode -> Component.translatable((String)("config.immersivemc.placement_guide_mode." + guideMode.ordinal())), guideMode -> Component.translatable((String)"config.immersivemc.placement_guide_mode.desc"), () -> ConfigScreen.getClientConfigIfAdjusting().placementGuideMode, (newModeIndex, newMode) -> {
            ConfigScreen.getClientConfigIfAdjusting().placementGuideMode = newMode;
        }));
        this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.item_guide_size", value -> Component.literal((String)(I18n.get((String)"config.immersivemc.item_guide_size", (Object[])new Object[0]) + ": " + String.format("%.02f", Float.valueOf((float)value.intValue() / 100.0f)))), 0, 100, () -> (int)(ConfigScreen.getClientConfigIfAdjusting().itemGuideSize * 100.0), newVal -> {
            ConfigScreen.getClientConfigIfAdjusting().itemGuideSize = (double)newVal.intValue() / 100.0;
        }));
        this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.item_guide_selected_size", value -> Component.literal((String)(I18n.get((String)"config.immersivemc.item_guide_selected_size", (Object[])new Object[0]) + ": " + String.format("%.02f", Float.valueOf((float)value.intValue() / 100.0f)))), 0, 100, () -> (int)(ConfigScreen.getClientConfigIfAdjusting().itemGuideSelectedSize * 100.0), newVal -> {
            ConfigScreen.getClientConfigIfAdjusting().itemGuideSelectedSize = (double)newVal.intValue() / 100.0;
        }));
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset != ItemGuidePreset.CUSTOM) {
            this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.ranged_grab_a", value -> Component.literal((String)(I18n.get((String)"config.immersivemc.ranged_grab_a", (Object[])new Object[0]) + ": " + value)), 0, 255, () -> ConfigScreen.getClientConfigIfAdjusting().colorPresetRangedGrabSize, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().colorPresetRangedGrabSize = newVal;
            }));
        }
        this.list.addBig(ScreenUtils.createEnumOption(ItemGuidePreset.class, "config.immersivemc.item_guide_preset", preset -> Component.translatable((String)("config.immersivemc.item_guide_preset." + preset.ordinal())), preset -> Component.literal((String)(I18n.get((String)"config.immersivemc.item_guide_preset.desc", (Object[])new Object[0]) + "\n\n" + I18n.get((String)("config.immersivemc.item_guide_preset." + preset.ordinal() + ".desc"), (Object[])new Object[0]))), () -> ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset, (newPresetIndex, newPreset) -> {
            ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset = newPreset;
            Minecraft.getInstance().setScreen((Screen)new ItemGuideCustomizeScreen(this.lastScreen));
        }));
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset == ItemGuidePreset.PRIDE_FLAG) {
            this.list.addBig(ScreenUtils.createEnumOption(ItemGuidePreset.PrideFlag.class, "config.immersivemc.item_guide_preset.pride_flag_option", flag -> Component.translatable((String)("config.immersivemc.item_guide_preset.pride_flag_option." + flag.name().toLowerCase())), flag -> Component.empty(), () -> ConfigScreen.getClientConfigIfAdjusting().itemGuidePrideFlag, (newFlagIndex, newFlag) -> {
                ConfigScreen.getClientConfigIfAdjusting().itemGuidePrideFlag = newFlag;
            }));
        }
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset.isCustomizablePreset()) {
            this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.item_guide_a", value -> Component.literal((String)(I18n.get((String)"config.immersivemc.item_guide_a", (Object[])new Object[0]) + ": " + value)), 0, 255, () -> ConfigScreen.getClientConfigIfAdjusting().colorPresetAlpha, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().colorPresetAlpha = newVal;
            }));
            this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.item_guide_selected_a", value -> Component.literal((String)(I18n.get((String)"config.immersivemc.item_guide_selected_a", (Object[])new Object[0]) + ": " + value)), 0, 255, () -> ConfigScreen.getClientConfigIfAdjusting().colorPresetSelectedAlpha, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().colorPresetSelectedAlpha = newVal;
            }));
        }
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset.showTransitionConfig()) {
            this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.item_guide_transition_time", value -> Component.translatable((String)"config.immersivemc.item_guide_transition_time_value", (Object[])new Object[]{String.format("%.02f", Float.valueOf((float)value.intValue() / 1000.0f))}), 500, 60000, () -> ConfigScreen.getClientConfigIfAdjusting().multiColorPresetTransitionTimeMS, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().multiColorPresetTransitionTimeMS = newVal;
                ConfigScreen.getClientConfigIfAdjusting().itemGuideCustomColorData = ConfigScreen.getClientConfigIfAdjusting().itemGuideCustomColorData.withChangedTransitionTime((int)newVal);
            }));
        }
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset == ItemGuidePreset.CUSTOM) {
            ItemGuideColorData colorData = ActiveConfig.FILE_CLIENT.itemGuideCustomColorData;
            for (String key : types) {
                List<RGBA> colors = key.equals(types[0]) ? colorData.colors().get() : (key.equals(types[1]) ? colorData.selectedColors().get() : colorData.rangedGrabColors().get());
                this.list.addBig(ScreenUtils.createIntSlider("config.immersivemc.num_custom_colors." + key, value -> Component.literal((String)(I18n.get((String)("config.immersivemc.num_custom_colors." + key), (Object[])new Object[0]) + ": " + value)), 1, 10, colors::size, newVal -> {
                    List<RGBA> newColors = new ArrayList<RGBA>(colors);
                    while (newVal > newColors.size()) {
                        newColors.add(RGBA.random());
                    }
                    if (newVal < newColors.size()) {
                        newColors = newColors.subList(0, (int)newVal);
                    }
                    ArrayList<RGBA> newColorsFinal = newColors;
                    ActiveConfig.FILE_CLIENT.itemGuideCustomColorData = key.equals(types[0]) ? new ItemGuideColorData(() -> newColorsFinal, colorData.selectedColors(), colorData.rangedGrabColors(), colorData.transitionTimeMS()) : (key.equals(types[1]) ? new ItemGuideColorData(colorData.colors(), () -> newColorsFinal, colorData.rangedGrabColors(), colorData.transitionTimeMS()) : new ItemGuideColorData(colorData.colors(), colorData.selectedColors(), () -> newColorsFinal, colorData.transitionTimeMS()));
                    ClientRenderSubscriber.resetCycleProgresses();
                    Minecraft.getInstance().setScreen((Screen)new ItemGuideCustomizeScreen(this.lastScreen));
                }));
                this.addColorOptions(colors, key);
            }
        }
    }

    private void addColorOptions(List<RGBA> colors, String key) {
        for (int i = 0; i < colors.size(); ++i) {
            RGBA color = colors.get(i);
            for (char c : rgba) {
                String compKey = "config.immersivemc." + key + "." + c;
                int readableColorNum = i + 1;
                this.list.addBig(ScreenUtils.createIntSlider(compKey, value -> Component.translatable((String)compKey, (Object[])new Object[]{String.valueOf(readableColorNum), String.valueOf(value)}), 0, 255, () -> color.getColor(c), newVal -> color.setColor(c, (int)newVal)));
            }
        }
    }

    public void onClose() {
        ConfigScreen.writeAdjustingConfig();
        super.onClose();
    }
}

