/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ConfigType;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ScreenUtils {
    public static OptionInstance<Integer> createIntSlider(String titleTranslationKey, Function<Integer, Component> displayTextCreator, int minValue, int maxValue, Supplier<Integer> valueGetter, Consumer<Integer> valueSetter) {
        return new OptionInstance(titleTranslationKey, OptionInstance.noTooltip(), (component, integer) -> (Component)displayTextCreator.apply((Integer)integer), (OptionInstance.ValueSet)new OptionInstance.IntRange(minValue, maxValue), (Object)valueGetter.get(), valueSetter);
    }

    public static OptionInstance<Boolean> createOption(String keyName, Function<ActiveConfig, Boolean> valueGetter, BiConsumer<ActiveConfig, Boolean> valueSetter) {
        return OptionInstance.createBoolean((String)("config.immersivemc." + keyName), (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)("config.immersivemc." + keyName + ".desc"))), (boolean)valueGetter.apply(ConfigScreen.getAdjustingConfig()), newVal -> valueSetter.accept(ConfigScreen.getAdjustingConfig(), (Boolean)newVal));
    }

    public static OptionInstance<Boolean> createOption(String keyName, @Nullable Component tooltip, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return OptionInstance.createBoolean((String)keyName, (OptionInstance.TooltipSupplier)(tooltip == null ? obj -> null : OptionInstance.cachedConstantTooltip((Component)tooltip)), (boolean)getter.get(), setter);
    }

    public static <E extends Enum<E>> OptionInstance<E> createEnumOption(Class<E> enumClass, String titleTranslationKey, Function<E, Component> displayTextCreator, Function<E, Component> tooltipTextCreator, Supplier<E> valueGetter, BiConsumer<Integer, E> valueSetter) {
        return new OptionInstance(titleTranslationKey, value -> Tooltip.create((Component)((Component)tooltipTextCreator.apply(value))), (component, value) -> (Component)displayTextCreator.apply(value), (OptionInstance.ValueSet)new OptionInstance.LazyEnum(() -> Arrays.asList((Enum[])enumClass.getEnumConstants()), Optional::of, null), (Object)((Enum)valueGetter.get()), newValue -> valueSetter.accept(newValue.ordinal(), newValue));
    }

    public static Button createScreenButton(int x, int y, int width, int height, String translationString, Screen screen) {
        return ScreenUtils.createButton(x, y, width, height, translationString, button -> Minecraft.getInstance().setScreen(screen));
    }

    public static Button createDoneButton(int x, int y, int width, int height, Screen currentScreen) {
        return ScreenUtils.createButton(x, y, width, height, "gui.done", button -> currentScreen.onClose());
    }

    public static Button createButton(int x, int y, int width, int height, String translationString, Consumer<Button> clickHandler) {
        return ScreenUtils.createButton(x, y, width, height, translationString, null, clickHandler);
    }

    public static Button createButton(int x, int y, int width, int height, String translationString, String tooltipTranslationString, Consumer<Button> clickHandler) {
        return Button.builder((Component)Component.translatable((String)translationString), clickHandler::accept).size(width, height).pos(x, y).tooltip(tooltipTranslationString == null ? null : Tooltip.create((Component)Component.translatable((String)tooltipTranslationString))).build();
    }

    public static void addOptionIfModLoaded(String modId, String keyName, Function<ActiveConfig, Boolean> valueGetter, BiConsumer<ActiveConfig, Boolean> valueSetter, OptionsList list) {
        if (Platform.isModLoaded(modId)) {
            ScreenUtils.addOption(keyName, valueGetter, valueSetter, list);
        }
    }

    public static void addOption(String keyName, Function<ActiveConfig, Boolean> valueGetter, BiConsumer<ActiveConfig, Boolean> valueSetter, OptionsList list) {
        list.addBig(ScreenUtils.createOption(keyName, valueGetter, valueSetter));
    }

    public static void addOptionIfClient(String keyName, Function<ClientActiveConfig, Boolean> valueGetter, BiConsumer<ClientActiveConfig, Boolean> valueSetter, OptionsList list) {
        if (ConfigScreen.getAdjustingConfigType() == ConfigType.CLIENT) {
            list.addBig(ScreenUtils.createOption(keyName, ac -> (Boolean)valueGetter.apply((ClientActiveConfig)ac), (ac, newVal) -> valueSetter.accept((ClientActiveConfig)ac, (Boolean)newVal)));
        }
    }

    public static boolean mouseInBox(int mouseX, int mouseY, int leftX, int bottomY, int rightX, int topY) {
        return mouseX >= leftX && mouseX <= rightX && mouseY >= bottomY && mouseY <= topY;
    }
}

