/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.immersive.info.DragImmersiveInfo;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blf02.vrapi.api.data.IVRData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDragImmersive
implements Immersive<DragImmersiveInfo, NullStorage> {
    protected final List<DragImmersiveInfo> trackedObjects = new ArrayList<DragImmersiveInfo>();

    protected abstract void hitboxDragged(DragImmersiveInfo var1, int var2, int var3, int var4);

    protected abstract AutoDragSettings autoDragSettings();

    protected void makeHitboxes(DragImmersiveInfo info, Level level) {
    }

    @Override
    public Collection<DragImmersiveInfo> getTrackedObjects() {
        return this.trackedObjects;
    }

    @Override
    public int handleHitboxInteract(DragImmersiveInfo info, LocalPlayer player, List<Integer> hitboxIndices, InteractionHand hand, boolean modifierPressed) {
        return -1;
    }

    @Override
    public boolean shouldRender(DragImmersiveInfo info) {
        return true;
    }

    @Override
    public void render(DragImmersiveInfo info, PoseStack stack, ImmersiveRenderHelpers helpers, float partialTick) {
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            HitboxInfo hitbox = info.hitboxes.get(i);
            AutoDragSettings autoDrag = this.autoDragSettings();
            float blue = info.startingHitboxIndex != i ? 1.0f : 0.0f;
            float red = !autoDrag.nonInteractables.contains(i) ? blue : 0.0f;
            helpers.renderHitbox(stack, hitbox.getHitbox(), false, red, 1.0f, blue);
        }
    }

    @Override
    public void tick(DragImmersiveInfo info) {
        AutoDragSettings autoDrag = this.autoDragSettings();
        ++info.ticksExisted;
        if (autoDrag.makeHitboxesEveryTick) {
            this.makeHitboxes(info, (Level)Minecraft.getInstance().level);
        }
        for (int c = 0; c <= 1; ++c) {
            IVRData hand = VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player).getController(c);
            int lastGrabbed = info.grabbedBox[c];
            int grabbed = Util.getFirstIntersect(hand.position(), info.getAllHitboxes().stream().map(HitboxInfo::getHitbox).toList()).orElse(-1);
            if (!(lastGrabbed != info.startingHitboxIndex && info.startingHitboxIndex != -1 || grabbed <= -1 || lastGrabbed == grabbed || autoDrag.nonInteractables.contains(grabbed))) {
                this.hitboxDragged(info, c, lastGrabbed, grabbed);
            }
            if (autoDrag.nonInteractables.contains(grabbed)) continue;
            info.grabbedBox[c] = grabbed;
        }
    }

    @Nullable
    public AABB getDragHitbox(DragImmersiveInfo info) {
        return null;
    }

    @Override
    public boolean isInputHitbox(DragImmersiveInfo info, int hitboxIndex) {
        return true;
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(DragImmersiveInfo info) {
        return VRPluginVerify.clientInVR();
    }

    @Override
    public void processStorageFromNetwork(DragImmersiveInfo info, NullStorage storage) {
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    public record AutoDragSettings(Collection<Integer> nonInteractables, boolean makeHitboxesEveryTick) {
    }
}

