/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.api_impl.ImmersiveRenderHelpersImpl;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlayerAttachmentImmersive<I extends AbstractPlayerAttachmentInfo, S extends NetworkStorage> {
    public static final int maxLight = LightTexture.pack((int)15, (int)15);
    protected final List<I> infos;
    public final int maxImmersives;
    protected boolean forceDisableItemGuide = false;
    public boolean forceTickEvenIfNoTrack = false;

    public AbstractPlayerAttachmentImmersive(int maxImmersives) {
        Immersives.IMMERSIVE_ATTACHMENTS.add(this);
        this.maxImmersives = maxImmersives;
        this.infos = new ArrayList<I>(maxImmersives > 0 ? maxImmersives + 1 : 16);
    }

    public Vec3 playerPos() {
        return ClientUtil.playerPos();
    }

    protected void renderTick(I info, boolean isInVR) {
    }

    public void globalTick() {
    }

    public boolean clientAuthoritative() {
        return false;
    }

    @Nullable
    public abstract ImmersiveHandler<S> getHandler();

    public boolean hitboxesAvailable(AbstractPlayerAttachmentInfo info) {
        return true;
    }

    public abstract boolean shouldRender(I var1, boolean var2);

    protected abstract void render(I var1, PoseStack var2, boolean var3);

    public abstract boolean enabledInConfig();

    protected abstract boolean inputSlotShouldRenderHelpHitbox(I var1, int var2);

    public abstract boolean shouldTrack(BlockPos var1, Level var2);

    @Nullable
    public abstract I refreshOrTrackObject(BlockPos var1, Level var2);

    public abstract boolean shouldBlockClickIfEnabled(AbstractPlayerAttachmentInfo var1);

    protected abstract void initInfo(I var1);

    public void onAnyRightClick(AbstractPlayerAttachmentInfo info) {
    }

    public boolean isVROnly() {
        return false;
    }

    public abstract void handleRightClick(AbstractPlayerAttachmentInfo var1, Player var2, int var3, InteractionHand var4);

    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes info, Player player, int hitboxNum) {
    }

    public void onRemove(I info) {
    }

    protected boolean slotHelpBoxIsSelected(I info, int slotNum) {
        return ((AbstractPlayerAttachmentInfo)info).slotHovered(slotNum);
    }

    public abstract void processStorageFromNetwork(AbstractPlayerAttachmentInfo var1, S var2);

    public void tick(I info, boolean isInVR) {
        if (this.enabledInConfig()) {
            if (!((AbstractPlayerAttachmentInfo)info).initCompleted) {
                this.initInfo(info);
                ((AbstractPlayerAttachmentInfo)info).initCompleted = true;
            }
            if (Minecraft.getInstance().level != null && (this.shouldTrack(((AbstractPlayerAttachmentInfo)info).getBlockPosition(), (Level)Minecraft.getInstance().level) || this.forceTickEvenIfNoTrack)) {
                this.doTick(info, isInVR);
                ((AbstractPlayerAttachmentInfo)info).setInputSlots();
                ((AbstractPlayerAttachmentInfo)info).light = this.hasMultipleLightPositions(info) ? this.getLight(this.getLightPositions(info)) : this.getLight(this.getLightPos(info));
            } else {
                ((AbstractPlayerAttachmentInfo)info).remove();
            }
        }
    }

    public int getCooldownVR() {
        return 12;
    }

    public int getCooldownDesktop() {
        return 8;
    }

    protected void doTick(I info, boolean isInVR) {
        if (((AbstractPlayerAttachmentInfo)info).getItemTransitionCountdown() > 1 && ((AbstractPlayerAttachmentInfo)info).getTicksLeft() > 20) {
            ((AbstractPlayerAttachmentInfo)info).changeItemTransitionCountdown(-1);
        } else if (((AbstractPlayerAttachmentInfo)info).getItemTransitionCountdown() < 10 && ((AbstractPlayerAttachmentInfo)info).getTicksLeft() <= 20) {
            ((AbstractPlayerAttachmentInfo)info).changeItemTransitionCountdown(1);
        }
        if (((AbstractPlayerAttachmentInfo)info).getTicksLeft() > 0) {
            ((AbstractPlayerAttachmentInfo)info).changeTicksLeft(-1);
        }
        ++((AbstractPlayerAttachmentInfo)info).ticksActive;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.distanceToSqr(Vec3.atCenterOf((Vec3i)((AbstractPlayerAttachmentInfo)info).getBlockPosition())) > 256.0) {
            ((AbstractPlayerAttachmentInfo)info).remove();
        }
    }

    public abstract BlockPos getLightPos(I var1);

    public boolean hasMultipleLightPositions(I info) {
        return false;
    }

    public BlockPos[] getLightPositions(I info) {
        return new BlockPos[0];
    }

    public void doRender(I info, PoseStack stack, boolean isInVR) {
        if (this.shouldRender(info, isInVR)) {
            try {
                this.renderTick(info, isInVR);
                this.render(info, stack, isInVR);
                if (ActiveConfig.active().placementGuideMode != PlacementGuideMode.OFF && !this.forceDisableItemGuide && this.nearbyItemGuideRenderCheck(info)) {
                    for (int i = 0; i < ((AbstractPlayerAttachmentInfo)info).getInputSlots().length; ++i) {
                        if (!this.inputSlotShouldRenderHelpHitbox(info, i)) continue;
                        BoundingBox itemBox = ((AbstractPlayerAttachmentInfo)info).getInputSlots()[i];
                        this.enqueueItemGuideRender(stack, itemBox, 0.2f, this.slotHelpBoxIsSelected(info, i), ((AbstractPlayerAttachmentInfo)info).light);
                    }
                }
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                // empty catch block
            }
        }
    }

    private boolean nearbyItemGuideRenderCheck(I info) {
        HitResult hit = Minecraft.getInstance().hitResult;
        LocalPlayer player = Minecraft.getInstance().player;
        boolean inVR = VRPluginVerify.clientInVR();
        Vec3 vrHitStart = inVR ? VRPlugin.API.getVRPlayer((Player)player).getHMD().position() : null;
        Vec3 vrLook = inVR ? VRPlugin.API.getVRPlayer((Player)player).getHMD().getLookAngle() : null;
        Vec3 vrHitEnd = inVR ? vrHitStart.add(vrLook.scale(Minecraft.getInstance().player.blockInteractionRange())) : null;
        BlockHitResult vrHit = inVR ? player.level().clip(new ClipContext(vrHitStart, vrHitEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)) : null;
        return hit != null && hit.getType() == HitResult.Type.BLOCK && ((BlockHitResult)hit).getBlockPos().equals((Object)((AbstractPlayerAttachmentInfo)info).getBlockPosition()) || this.playerPos().distanceTo(Vec3.atCenterOf((Vec3i)((AbstractPlayerAttachmentInfo)info).getBlockPosition())) <= 4.0 || vrHit != null && vrHit.getType() == HitResult.Type.BLOCK && vrHit.getBlockPos().equals((Object)((AbstractPlayerAttachmentInfo)info).getBlockPosition());
    }

    public List<I> getTrackedObjects() {
        return this.infos;
    }

    public void noInfosTick() {
    }

    public void renderItem(ItemStack item, PoseStack stack, Vec3 pos, float size, Direction facing, BoundingBox hitbox, boolean renderItemCounts, int light) {
        this.renderItem(item, stack, pos, size, facing, null, hitbox, renderItemCounts, -1, light);
    }

    public void renderItem(ItemStack item, PoseStack stack, Vec3 pos, float size, Direction facing, Direction upDown, BoundingBox hitbox, boolean renderItemCounts, int spinDegrees, int light) {
        ImmersiveRenderHelpersImpl.INSTANCE.renderItem(item, stack, size, hitbox, renderItemCounts, light, spinDegrees < 0 ? null : Float.valueOf(spinDegrees), facing, upDown);
    }

    protected void enqueueItemGuideRender(PoseStack stack, BoundingBox hitbox, float alpha, boolean isSelected, int light) {
        ClientRenderSubscriber.itemGuideRenderData.add(new ClientRenderSubscriber.ItemGuideRenderData(stack, hitbox, alpha, isSelected, light));
    }

    protected void renderHitbox(PoseStack stack, BoundingBox hitbox) {
        this.renderHitbox(stack, hitbox, false);
    }

    protected void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender) {
        AbstractPlayerAttachmentImmersive.renderHitbox(stack, hitbox, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    public static void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue) {
        AbstractPlayerAttachmentImmersive.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, 1.0f);
    }

    public static void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue, float alpha) {
        ImmersiveRenderHelpersImpl.INSTANCE.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, alpha);
    }

    public static Direction getLeftOfDirection(Direction forward) {
        if (forward == Direction.UP || forward == Direction.DOWN) {
            throw new IllegalArgumentException("Direction cannot be up or down!");
        }
        if (forward == Direction.NORTH) {
            return Direction.WEST;
        }
        if (forward == Direction.WEST) {
            return Direction.SOUTH;
        }
        if (forward == Direction.SOUTH) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    public static Vec3 getTopCenterOfBlock(BlockPos pos) {
        return Vec3.upFromBottomCenterOf((Vec3i)pos, (double)1.0);
    }

    public static Direction getForwardFromPlayer(Player player, BlockPos pos) {
        Direction.Axis axis;
        Vec3 blockPos = Vec3.atBottomCenterOf((Vec3i)pos);
        Vec3 playerPos = player.position();
        Vec3 diff = playerPos.subtract(blockPos);
        Direction.Axis axis2 = axis = Math.abs(diff.x) > Math.abs(diff.z) ? Direction.Axis.X : Direction.Axis.Z;
        if (axis == Direction.Axis.X) {
            return diff.x < 0.0 ? Direction.WEST : Direction.EAST;
        }
        return diff.z < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public static Vec3[] get3x3HorizontalGrid(BlockPos blockPos, double spacing, Direction blockForward, boolean use3DCompat) {
        Vec3 pos = AbstractPlayerAttachmentImmersive.getTopCenterOfBlock(blockPos);
        if (use3DCompat) {
            pos = pos.add(0.0, 0.0625, 0.0);
        }
        Direction left = AbstractPlayerAttachmentImmersive.getLeftOfDirection(blockForward);
        Vec3 leftOffset = new Vec3((double)left.getNormal().getX() * -spacing, 0.0, (double)left.getNormal().getZ() * -spacing);
        Vec3 rightOffset = new Vec3((double)left.getNormal().getX() * spacing, 0.0, (double)left.getNormal().getZ() * spacing);
        Vec3 topOffset = new Vec3((double)blockForward.getNormal().getX() * -spacing, 0.0, (double)blockForward.getNormal().getZ() * -spacing);
        Vec3 botOffset = new Vec3((double)blockForward.getNormal().getX() * spacing, 0.0, (double)blockForward.getNormal().getZ() * spacing);
        return new Vec3[]{pos.add(leftOffset).add(topOffset), pos.add(topOffset), pos.add(rightOffset).add(topOffset), pos.add(leftOffset), pos, pos.add(rightOffset), pos.add(leftOffset).add(botOffset), pos.add(botOffset), pos.add(rightOffset).add(botOffset)};
    }

    public int getLight(BlockPos pos) {
        return ImmersiveClientLogicHelpers.instance().getLight(pos);
    }

    public int getLight(BlockPos[] positions) {
        return ImmersiveClientLogicHelpers.instance().getLight(Arrays.stream(positions).toList());
    }

    public void clearImmersives() {
        this.infos.clear();
    }

    public static Direction getForwardFromPlayerUpAndDown(Player player, BlockPos pos) {
        return AbstractPlayerAttachmentImmersive.getForwardFromPlayerUpAndDownFilterBlockFacing(player, pos, false);
    }

    public static Direction getForwardFromPlayerUpAndDownFilterBlockFacing(Player player, BlockPos pos, boolean filterOnBlockFacing) {
        Direction.Axis filter = filterOnBlockFacing ? ((Direction)player.level().getBlockState(pos).getValue((Property)DirectionalBlock.FACING)).getAxis() : null;
        Vec3 playerPos = player.position();
        if (playerPos.y >= (double)pos.getY() + 0.625 && filter != Direction.Axis.Y) {
            return Direction.UP;
        }
        if (playerPos.y <= (double)pos.getY() - 0.625 && filter != Direction.Axis.Y) {
            return Direction.DOWN;
        }
        Direction forward = AbstractPlayerAttachmentImmersive.getForwardFromPlayer(player, pos);
        if (forward.getAxis() != filter) {
            return forward;
        }
        Direction blockFacing = (Direction)player.level().getBlockState(pos).getValue((Property)DirectionalBlock.FACING);
        Vec3 blockCenter = Vec3.atCenterOf((Vec3i)pos);
        Direction blockLeftDir = blockFacing.getCounterClockWise();
        Vec3 blockLeftVec = new Vec3((double)blockLeftDir.getNormal().getX(), (double)blockLeftDir.getNormal().getY(), (double)blockLeftDir.getNormal().getZ());
        Vec3 counterClockwisePos = blockCenter.add(blockLeftVec.scale(0.5));
        Vec3 clockwisePos = blockCenter.add(blockLeftVec.scale(-0.5));
        Vec3 upPos = blockCenter.add(0.0, 0.5, 0.0);
        Vec3 downPos = blockCenter.add(0.0, -0.5, 0.0);
        double counterClockwiseDist = counterClockwisePos.distanceToSqr(playerPos);
        double clockwiseDist = clockwisePos.distanceToSqr(playerPos);
        double upDist = upPos.distanceToSqr(playerPos);
        double downDist = downPos.distanceToSqr(playerPos);
        double min = Math.min(counterClockwiseDist, clockwiseDist);
        min = Math.min(min, upDist);
        if ((min = Math.min(min, downDist)) == counterClockwiseDist) {
            return forward.getCounterClockWise();
        }
        if (min == clockwiseDist) {
            return forward.getClockWise();
        }
        if (min == upDist) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }
}

