/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersive;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.api.client.immersive.HitboxPositioningMode;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.ImmersiveBuilderImpl;
import com.hammy275.immersivemc.client.immersive.RelativeHitboxInfoImpl;
import com.hammy275.immersivemc.client.immersive.TextData;
import com.hammy275.immersivemc.client.immersive.info.BuiltImmersiveInfoImpl;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class BuiltImmersiveImpl<E, S extends NetworkStorage>
implements BuiltImmersive<E, S> {
    private final ImmersiveBuilderImpl<E, S> builder;
    private final List<BuiltImmersiveInfo<E>> infos = new ArrayList<BuiltImmersiveInfo<E>>();

    public BuiltImmersiveImpl(ImmersiveBuilderImpl<E, S> builder) {
        this.builder = builder;
    }

    @Override
    public ImmersiveHandler<S> getHandler() {
        return this.builder.handler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return this.builder.configScreenInfo;
    }

    @Override
    public boolean shouldRender(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return this.getHandler().isValidBlock(info.getBlockPosition(), (Level)Minecraft.getInstance().level) && info.hasHitboxes() && info.airCheckPassed && this.builder.extraRenderReady.apply(info) != false;
    }

    @Override
    public void tick(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        ++info.ticksExisted;
        Direction currentDir = switch (this.builder.positioningMode) {
            case HitboxPositioningMode.HORIZONTAL_BLOCK_FACING, HitboxPositioningMode.BLOCK_FACING_NEG_X, HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED, HitboxPositioningMode.TOP_BLOCK_FACING -> info.immersiveDir;
            case HitboxPositioningMode.TOP_PLAYER_FACING, HitboxPositioningMode.HORIZONTAL_PLAYER_FACING, HitboxPositioningMode.PLAYER_FACING_NO_DOWN -> ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.getInstance().player, info.getBlockPosition());
            case HitboxPositioningMode.TOP_LITERAL -> null;
            case HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING -> Util.getForwardFromPlayerUpAndDownFilterBlockFacing((Player)Minecraft.getInstance().player, info.getBlockPosition(), true);
            default -> throw new UnsupportedOperationException("Facing direction for positioning mode " + String.valueOf((Object)this.builder.positioningMode) + " unimplemented!");
        };
        boolean differentDirs = info.immersiveDir != currentDir;
        info.immersiveDir = currentDir;
        boolean didRecalc = false;
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            RelativeHitboxInfoImpl hitbox = info.hitboxes.get(i);
            if (!hitbox.constantOffset || differentDirs || !hitbox.calcDone() || this.builder.slotActive != null || hitbox.vrMovementInfo != null || hitbox.textSupplier != null || !hitbox.forcedUpDownRenderDirConstant) {
                didRecalc = true;
                if (this.builder.slotActive == null || this.builder.slotActive.apply(info, i).booleanValue()) {
                    hitbox.recalculate((Level)Minecraft.getInstance().level, this.builder.positioningMode, info);
                } else {
                    hitbox.forceNull();
                }
            }
            if (!differentDirs) continue;
            hitbox.onOrientationChange();
        }
        if (this.builder.dragHitboxCreator != null) {
            info.dragHitbox = this.builder.dragHitboxCreator.apply(info);
        } else if (didRecalc) {
            boolean validBox = false;
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double minZ = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double maxZ = Double.NEGATIVE_INFINITY;
            for (RelativeHitboxInfoImpl hitbox : info.hitboxes) {
                if (!hitbox.hasAABB() || !hitbox.isInput) continue;
                AABB aabb = hitbox.getAABB();
                minX = Math.min(minX, aabb.minX);
                minY = Math.min(minY, aabb.minY);
                minZ = Math.min(minZ, aabb.minZ);
                maxX = Math.max(maxX, aabb.maxX);
                maxY = Math.max(maxY, aabb.maxY);
                maxZ = Math.max(maxZ, aabb.maxZ);
                validBox = true;
            }
            info.dragHitbox = validBox ? new AABB(minX, minY, minZ, maxX, maxY, maxZ).inflate(0.0625) : null;
        }
        info.airCheckPassed = this.airCheck(info);
        info.light = ImmersiveClientLogicHelpers.instance().getLight(this.getLightPositions(info));
    }

    @Nullable
    public AABB getDragHitbox(BuiltImmersiveInfo<E> info) {
        return this.asImpl(info).dragHitbox;
    }

    @Override
    public boolean isInputHitbox(BuiltImmersiveInfo<E> infoIn, int hitboxIndex) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return info.hitboxes.get((int)hitboxIndex).isInput;
    }

    @Override
    public void render(BuiltImmersiveInfo<E> infoIn, PoseStack stack, ImmersiveRenderHelpers helpers, float partialTick) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        float size = ImmersiveRenderHelpers.instance().getTransitionMultiplier(info.ticksExisted) * this.builder.renderSize;
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            RelativeHitboxInfoImpl hitbox = info.hitboxes.get(i);
            if (!hitbox.hasAABB()) continue;
            AABB renderBox = hitbox.getRenderHitbox(partialTick);
            Vec3 renderPos = renderBox.getCenter();
            if (hitbox.holdsItems && (hitbox.renderItem || hitbox.item == null || hitbox.item.isEmpty())) {
                Float spinDegrees;
                Float f = spinDegrees = hitbox.itemSpins ? Float.valueOf((float)info.ticksExisted % 100.0f * 3.6f) : null;
                if (hitbox.item == null || hitbox.item.isEmpty()) {
                    if (hitbox.isInput && this.builder.slotRendersItemGuide.apply(info, i).booleanValue()) {
                        helpers.renderItemGuide(stack, (BoundingBox)renderBox, info.isSlotHovered(i), info.light);
                    }
                } else {
                    float renderSize = size * hitbox.itemRenderSizeMultiplier;
                    if (info.isSlotHovered(i)) {
                        renderSize *= ImmersiveRenderHelpers.instance().hoverScaleSizeMultiplier();
                    }
                    Direction itemDir = info.immersiveDir;
                    if (hitbox.itemRotationType != null) {
                        itemDir = hitbox.itemRotationType.transform(itemDir);
                    }
                    helpers.renderItem(hitbox.item, stack, renderSize, (BoundingBox)renderBox, hitbox.renderItemCount, info.light, spinDegrees, itemDir, hitbox.getUpDownRenderDir());
                }
            } else {
                helpers.renderHitbox(stack, (BoundingBox)renderBox);
            }
            for (TextData data : hitbox.getTextData()) {
                helpers.renderText(data.text(), stack, renderPos.add(data.offset()), info.light, 0.02f);
            }
        }
        if (info.dragHitbox != null) {
            helpers.renderHitbox(stack, (BoundingBox)info.dragHitbox, false, 0.0f, 1.0f, 1.0f);
        }
        this.builder.extraRenderer.render(infoIn, stack, helpers, partialTick, info.light);
    }

    @Override
    public BuiltImmersiveInfo<E> buildInfo(BlockPos pos, Level level) {
        BuiltImmersiveInfoImpl info;
        BlockState state = level.getBlockState(pos);
        if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_PLAYER_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_LITERAL) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        } else if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        } else if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (state.getValue((Property)BlockStateProperties.ATTACH_FACE) != AttachFace.WALL) {
                info.immersiveDir = info.immersiveDir.getOpposite();
            }
        } else {
            throw new UnsupportedOperationException("Tracking for positioning mode " + String.valueOf((Object)this.builder.positioningMode) + " unimplemented!");
        }
        return info;
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(BuiltImmersiveInfo<E> info) {
        return this.builder.blockRightClickWhenGUIClickDisabled;
    }

    @Override
    public Collection<BuiltImmersiveInfo<E>> getTrackedObjects() {
        return this.infos;
    }

    @Override
    public int handleHitboxInteract(BuiltImmersiveInfo<E> infoIn, LocalPlayer player, List<Integer> hitboxIndices, InteractionHand hand, boolean modifierPressed) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return this.builder.hitboxInteractHandler.apply(info, (Player)player, hitboxIndices, hand, modifierPressed);
    }

    private boolean airCheck(BuiltImmersiveInfo<E> infoIn) {
        AbstractCollection positions;
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (this.builder.airCheckPositionOffsets.isEmpty()) {
            positions = new HashSet();
            info.hitboxes.forEach(hitbox -> {
                if (hitbox.hasAABB()) {
                    positions.addAll(Util.allPositionsWithAABB(hitbox.getAABB()));
                }
            });
            BlockPos immersivePos = info.getBlockPosition();
            positions.remove(immersivePos);
            positions.removeIf(pos -> Math.abs(pos.getX() - immersivePos.getX()) > 1 || Math.abs(pos.getY() - immersivePos.getY()) > 1 || Math.abs(pos.getZ() - immersivePos.getZ()) > 1);
        } else {
            positions = new ArrayList();
            for (Vec3i offset : this.builder.airCheckPositionOffsets) {
                positions.add(info.getBlockPosition().offset(offset));
            }
        }
        for (BlockPos pos2 : positions) {
            AABB shape;
            double volume;
            VoxelShape voxelShape;
            BlockState state = Minecraft.getInstance().level.getBlockState(pos2);
            if (state.canBeReplaced() || (voxelShape = state.getShape((BlockGetter)Minecraft.getInstance().level, pos2)).isEmpty() || !((volume = (shape = voxelShape.bounds()).getXsize() * shape.getYsize() * shape.getZsize()) > 0.3333333333333333)) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getLightPositions(BuiltImmersiveInfo<E> info) {
        if (this.builder.lightPositionOffsets.size() > 1) {
            ArrayList<BlockPos> lightPositions = new ArrayList<BlockPos>();
            for (Vec3i offset : this.builder.lightPositionOffsets) {
                lightPositions.add(info.getBlockPosition().offset(offset));
            }
            return lightPositions;
        }
        if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            ArrayList<BlockPos> lightPositions = new ArrayList<BlockPos>();
            Direction.Axis ignored = ((Direction)Minecraft.getInstance().player.level().getBlockState(info.getBlockPosition()).getValue((Property)DirectionalBlock.FACING)).getAxis();
            for (Direction dir : Direction.values()) {
                if (dir.getAxis() == ignored) continue;
                lightPositions.add(info.getBlockPosition().relative(dir));
            }
            return lightPositions;
        }
        return List.of(this.getLightPos(info));
    }

    public BlockPos getLightPos(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (this.builder.lightPositionOffsets.isEmpty()) {
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
                return info.getBlockPosition().relative(info.immersiveDir);
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_PLAYER_FACING) {
                return info.getBlockPosition().above();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_LITERAL) {
                return info.getBlockPosition().above();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_BLOCK_FACING) {
                return info.getBlockPosition().above();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
                return info.getBlockPosition().relative(ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.getInstance().player, info.getBlockPosition()));
            }
            if (this.builder.positioningMode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
                return info.getBlockPosition().relative(info.immersiveDir);
            }
            if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
                return info.getBlockPosition().relative(Util.getForwardFromPlayerUpAndDown((Player)Minecraft.getInstance().player, info.getBlockPosition()));
            }
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
                BlockState state = Minecraft.getInstance().level.getBlockState(info.getBlockPosition());
                return switch ((AttachFace)state.getValue((Property)BlockStateProperties.ATTACH_FACE)) {
                    default -> throw new MatchException(null, null);
                    case AttachFace.FLOOR -> info.getBlockPosition().above();
                    case AttachFace.WALL -> info.getBlockPosition().relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
                    case AttachFace.CEILING -> info.getBlockPosition().below();
                };
            }
            throw new UnsupportedOperationException("Light pos for positioning mode " + String.valueOf((Object)this.builder.positioningMode) + " unimplemented!");
        }
        return info.getBlockPosition().offset(this.builder.lightPositionOffsets.get(0));
    }

    @Override
    public void processStorageFromNetwork(BuiltImmersiveInfo<E> infoIn, S storage) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (storage instanceof ListOfItemsStorage) {
            ListOfItemsStorage itemsStorage = (ListOfItemsStorage)storage;
            for (int i = 0; i < itemsStorage.getItems().size(); ++i) {
                info.hitboxes.get((int)i).item = itemsStorage.getItems().get(i);
            }
        } else if (storage instanceof ItemStorage) {
            ItemStorage iws = (ItemStorage)storage;
            for (int i = 0; i < iws.getNumItems(); ++i) {
                info.hitboxes.get((int)i).item = iws.getItem(i);
            }
        }
        if (this.builder.extraStorageConsumer != null) {
            this.builder.extraStorageConsumer.accept(storage, info);
        }
    }

    @Override
    public boolean isVROnly() {
        return this.builder.vrOnly;
    }

    @Override
    public <T extends NetworkStorage> ImmersiveBuilderImpl<E, T> getBuilderClone(ImmersiveHandler<T> newHandler) {
        return this.builder.copy((ImmersiveHandler)newHandler);
    }

    private BuiltImmersiveInfoImpl<E> asImpl(BuiltImmersiveInfo<E> infoIn) {
        return (BuiltImmersiveInfoImpl)infoIn;
    }
}

