/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.SwapMode;
import com.hammy275.immersivemc.client.compat.ipn.IPN;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive.info.BackpackInfo;
import com.hammy275.immersivemc.client.model.BackpackBundleModel;
import com.hammy275.immersivemc.client.model.BackpackCraftingModel;
import com.hammy275.immersivemc.client.model.BackpackLowDetailModel;
import com.hammy275.immersivemc.client.model.BackpackModel;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.FetchBackpackStoragePacket;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.swap.Swap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ImmersiveBackpack
extends AbstractPlayerAttachmentImmersive<BackpackInfo, NullStorage> {
    public static final BackpackBundleModel bundleModel = new BackpackBundleModel(Minecraft.getInstance().getEntityModels().bakeLayer(BackpackBundleModel.LAYER_LOCATION));
    public static final BackpackModel model = new BackpackModel(Minecraft.getInstance().getEntityModels().bakeLayer(BackpackModel.LAYER_LOCATION));
    public static final BackpackLowDetailModel modelLowDetail = new BackpackLowDetailModel(Minecraft.getInstance().getEntityModels().bakeLayer(BackpackLowDetailModel.LAYER_LOCATION));
    public static final BackpackCraftingModel craftingModel = new BackpackCraftingModel(Minecraft.getInstance().getEntityModels().bakeLayer(BackpackCraftingModel.LAYER_LOCATION));
    private static final int maxColor = -1;
    private final double spacing = 0.375;

    public ImmersiveBackpack() {
        super(1);
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    @Override
    protected void renderTick(BackpackInfo info, boolean isInVR) {
        super.renderTick(info, isInVR);
        IVRPlayer vrPlayer = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player) : VRPlugin.API.getRenderVRPlayer();
        this.calculatePositions(info, vrPlayer);
    }

    @Override
    protected void doTick(BackpackInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        info.light = this.getLight(this.getLightPos(info));
    }

    @Override
    @Nullable
    public ImmersiveHandler getHandler() {
        return null;
    }

    @Override
    public BlockPos getLightPos(BackpackInfo info) {
        BlockPos c1 = BlockPos.containing((Position)VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player).getController(this.getBagControllerNum()).position());
        if (!Minecraft.getInstance().level.getBlockState(c1).canOcclude()) {
            return c1;
        }
        return BlockPos.containing((Position)VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player).getHMD().position());
    }

    public static void onHitboxInteract(Player player, BackpackInfo info, int slot) {
        if (slot <= 26) {
            Inventory inventory = player.getInventory();
            if (IPN.ipnCompat.available() && !Util.stacksEqualBesidesCount(inventory.getItem(slot + 9), inventory.getItem(inventory.selected))) {
                IPN.ipnCompat.doInventorySwap(slot + 9, inventory.selected);
            } else {
                Network.INSTANCE.sendToServer(new SwapPacket(BlockPos.ZERO, List.of(Integer.valueOf(slot + 9)), InteractionHand.MAIN_HAND, SwapMode.SINGLE, SwapPacket.SwapDestination.INVENTORY));
                Swap.handleInventorySwap(player, slot + 9, InteractionHand.MAIN_HAND);
            }
        } else {
            Network.INSTANCE.sendToServer(new SwapPacket(BlockPos.ZERO, List.of(Integer.valueOf(slot)), InteractionHand.MAIN_HAND, SwapMode.SINGLE, SwapPacket.SwapDestination.BAG_CRAFTING));
            Network.INSTANCE.sendToServer(new FetchBackpackStoragePacket());
        }
    }

    protected boolean inRange(int num, int start, int end) {
        return start <= num && num <= end;
    }

    @Override
    public boolean shouldRender(BackpackInfo info, boolean isInVR) {
        return Minecraft.getInstance().player != null && VRPluginVerify.hasAPI && VRPlugin.API.playerInVR((Player)Minecraft.getInstance().player) && VRPlugin.API.apiActive((Player)Minecraft.getInstance().player) && info.light >= 0;
    }

    @Override
    protected void render(BackpackInfo info, PoseStack stack, boolean isInVR) {
        float size;
        ItemStack item;
        int i;
        boolean leftHanded = this.leftHanded();
        for (i = 0; i <= 31; ++i) {
            this.renderHitbox(stack, info.getHitbox(i));
        }
        for (i = 0; i <= 26; ++i) {
            item = Minecraft.getInstance().player.getInventory().getItem(i + 9);
            if (item.isEmpty() || info.getPosition(i) == null) continue;
            size = info.slotHovered == i ? 0.3f : 0.2f;
            this.renderItem(item, stack, info.getPosition(i), size, null, info.getHitbox(i), true, info.light);
        }
        for (i = 27; i <= 31; ++i) {
            ItemStack itemStack = item = i == 31 ? info.craftingOutput : info.craftingInput[i - 27];
            if (item.isEmpty() || info.getPosition(i) == null) continue;
            size = info.slotHovered == i ? 0.3f : 0.2f;
            this.renderItem(item, stack, info.getPosition(i), size, null, info.getHitbox(i), true, info.light);
        }
        stack.pushPose();
        Vec3 pos = info.renderPos;
        Camera cameraInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        stack.translate(-cameraInfo.getPosition().x + pos.x, -cameraInfo.getPosition().y + pos.y, -cameraInfo.getPosition().z + pos.z);
        stack.scale(0.5f, 0.5f, 0.5f);
        stack.mulPose(Axis.YN.rotation(info.handYaw));
        stack.mulPose(Axis.XN.rotation(info.handPitch));
        stack.mulPose(Axis.ZP.rotation((float)Math.PI + info.handRoll));
        stack.translate(0.0f, -3.0f, 0.0f);
        ImmersiveBackpack.getBackpackModel().renderToBuffer(stack, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)ImmersiveBackpack.getBackpackTexture())), info.light, OverlayTexture.NO_OVERLAY, info.argb);
        stack.translate(leftHanded ? -0.75 : 0.75, 0.25, 0.0);
        craftingModel.renderToBuffer(stack, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)BackpackCraftingModel.textureLocation)), info.light, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
        if (ActiveConfig.active().placementGuideMode != PlacementGuideMode.OFF) {
            for (int i2 = 0; i2 < info.getInputSlots().length; ++i2) {
                if (!this.inputSlotShouldRenderHelpHitbox(info, i2)) continue;
                this.enqueueItemGuideRender(stack, info.getInputSlots()[i2], 0.2f, this.slotHelpBoxIsSelected(info, i2), info.light);
            }
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.active().useBagImmersive;
    }

    @Override
    protected boolean inputSlotShouldRenderHelpHitbox(BackpackInfo info, int slotNum) {
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        if (slotNum <= 26) {
            return Minecraft.getInstance().player.getInventory().getItem(slotNum + 9).isEmpty();
        }
        int tableIndex = slotNum - 27;
        return info.craftingInput[tableIndex] == null || info.craftingInput[tableIndex].isEmpty();
    }

    @Override
    public boolean shouldTrack(BlockPos pos, Level level) {
        return true;
    }

    @Override
    public BackpackInfo refreshOrTrackObject(BlockPos pos, Level level) {
        return null;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractPlayerAttachmentInfo info) {
        return false;
    }

    @Override
    protected void initInfo(BackpackInfo info) {
        Network.INSTANCE.sendToServer(new FetchBackpackStoragePacket());
    }

    @Override
    public void handleRightClick(AbstractPlayerAttachmentInfo info, Player player, int closest, InteractionHand hand) {
    }

    @Override
    public void processStorageFromNetwork(AbstractPlayerAttachmentInfo info, NullStorage storage) {
    }

    public void processFromNetwork(List<ItemStack> items) {
        if (this.infos.size() > 0) {
            BackpackInfo info = (BackpackInfo)this.infos.get(0);
            for (int i = 0; i <= 3; ++i) {
                info.craftingInput[i] = items.get(i);
            }
            info.craftingOutput = items.get(4);
        }
    }

    public void doTrack() {
        if (this.infos.isEmpty()) {
            this.infos.add(new BackpackInfo());
        } else {
            this.infos.clear();
        }
    }

    public static Model getBackpackModel() {
        switch (ActiveConfig.active().bagMode) {
            case BUNDLE: 
            case BUNDLE_COLORABLE: {
                return bundleModel;
            }
            case ORIGINAL: {
                return model;
            }
            case ORIGINAL_LOW_DETAIL: {
                return modelLowDetail;
            }
        }
        throw new IllegalArgumentException("backpackMode set to invalid enum value!");
    }

    public static ResourceLocation getBackpackTexture() {
        switch (ActiveConfig.active().bagMode) {
            case BUNDLE: {
                return BackpackBundleModel.textureLocation;
            }
            case BUNDLE_COLORABLE: {
                return BackpackBundleModel.textureLocationColorable;
            }
            case ORIGINAL: {
                return BackpackModel.textureLocation;
            }
            case ORIGINAL_LOW_DETAIL: {
                return BackpackLowDetailModel.textureLocation;
            }
        }
        throw new IllegalArgumentException("backpackMode set to invalid enum value!");
    }

    public static int getBackpackColor() {
        if (ActiveConfig.active().bagMode.colorable) {
            return ActiveConfig.active().bagColor | 0xFF000000;
        }
        return -1;
    }

    private Vec3 getRightVec(BackpackInfo info) {
        Vector3f leftF = new Vector3f(0.0f, 0.0f, 1.0f);
        leftF.rotate((Quaternionfc)Axis.YN.rotation(1.5707964f));
        leftF.rotate((Quaternionfc)Axis.ZP.rotation(info.handRoll));
        leftF.rotate((Quaternionfc)Axis.XN.rotation(info.handPitch));
        leftF.rotate((Quaternionfc)Axis.YN.rotation(info.handYaw));
        return new Vec3((double)leftF.x(), (double)leftF.y(), (double)leftF.z());
    }

    private void calculatePositions(BackpackInfo info, IVRPlayer vrPlayer) {
        IVRData backpackController = vrPlayer.getController(this.getBagControllerNum());
        info.handPos = backpackController.position();
        info.handPitch = (float)Math.toRadians(backpackController.getPitch());
        info.handYaw = (float)Math.toRadians(backpackController.getYaw());
        info.handRoll = (float)Math.toRadians(backpackController.getRoll());
        info.lookVec = backpackController.getLookAngle();
        Vec3 rightVec = this.getRightVec(info).scale(0.25);
        if (this.leftHanded()) {
            rightVec = rightVec.scale(-1.0);
        }
        Vec3 leftVec = rightVec.scale(-1.0);
        Vector3f downVecF = new Vector3f(0.0f, -1.0f, 0.0f);
        downVecF.rotate((Quaternionfc)Axis.ZP.rotation(info.handRoll));
        downVecF.rotate((Quaternionfc)Axis.XN.rotation(info.handPitch));
        downVecF.rotate((Quaternionfc)Axis.YN.rotation(info.handYaw));
        info.downVec = new Vec3((double)downVecF.x(), (double)downVecF.y(), (double)downVecF.z());
        info.backVec = info.lookVec.scale(-1.0);
        info.renderPos = info.handPos.add(info.downVec.scale(0.75));
        info.renderPos = info.renderPos.add(info.backVec.scale(0.16666666666666666));
        info.renderPos = info.renderPos.add(rightVec);
        info.argb = ImmersiveBackpack.getBackpackColor();
        info.centerTopPos = info.renderPos.add(info.downVec.scale(-0.7));
        Vec3 leftOffset = leftVec.scale(0.375);
        Vec3 rightOffset = rightVec.scale(0.375);
        double tbSpacing = 0.09375;
        Vec3 topOffset = info.lookVec.scale(tbSpacing);
        Vec3 botOffset = info.backVec.scale(tbSpacing);
        Vec3 pos = info.centerTopPos;
        Vec3[] positions = new Vec3[]{pos.add(leftOffset).add(topOffset), pos.add(topOffset), pos.add(rightOffset).add(topOffset), pos.add(leftOffset), pos, pos.add(rightOffset), pos.add(leftOffset).add(botOffset), pos.add(botOffset), pos.add(rightOffset).add(botOffset)};
        int start = 9 * info.topRow;
        int end = start + 8;
        int midStart = 9 * info.getMidRow();
        int midEnd = midStart + 8;
        Vec3 downOne = info.downVec.scale(0.105);
        Vec3 downTwo = downOne.scale(2.0);
        for (int i = 0; i <= 26; ++i) {
            Vec3 posRaw = positions[i % 9];
            Vec3 yDown = this.inRange(i, start, end) ? Vec3.ZERO : (this.inRange(i, midStart, midEnd) ? downOne : downTwo);
            Vec3 slotPos = posRaw;
            slotPos = slotPos.add(yDown);
            info.setPosition(i, slotPos);
            info.setHitbox(i, OBBFactory.instance().create(AABB.ofSize((Vec3)info.getPosition(i), (double)0.1f, (double)0.1f, (double)0.1f), info.handPitch, info.handYaw, info.handRoll));
        }
        Vec3 upVec = info.downVec.scale(-1.0);
        double upMult = 0.05;
        Vec3 leftCraftingPos = info.centerTopPos.add(rightVec.scale(1.25)).add(upVec.scale(upMult));
        Vec3 rightCraftingPos = info.centerTopPos.add(rightVec.scale(1.75)).add(upVec.scale(upMult));
        Vec3 centerCraftingPos = info.centerTopPos.add(rightVec.scale(1.5)).add(upVec.scale(upMult));
        double craftingOffset = 0.625;
        Vec3[] craftingPositions = new Vec3[]{leftCraftingPos.add(topOffset.scale(craftingOffset)), rightCraftingPos.add(topOffset.scale(craftingOffset)), leftCraftingPos.add(botOffset.scale(craftingOffset)), rightCraftingPos.add(botOffset.scale(craftingOffset))};
        for (int i = 27; i <= 30; ++i) {
            info.setPosition(i, craftingPositions[i - 27]);
            info.setHitbox(i, OBBFactory.instance().create(AABB.ofSize((Vec3)info.getPosition(i), (double)0.1f, (double)0.1f, (double)0.1f), info.handPitch, info.handYaw, info.handRoll));
        }
        info.setPosition(31, centerCraftingPos.add(upVec.scale(0.125)));
        info.setHitbox(31, OBBFactory.instance().create(AABB.ofSize((Vec3)info.getPosition(31), (double)0.1f, (double)0.1f, (double)0.1f), info.handPitch, info.handYaw, info.handRoll));
        info.setInputSlots();
    }

    private boolean leftHanded() {
        boolean useSwappedHands;
        boolean vrLeftHanded = VRPlugin.API.isLeftHanded((Player)Minecraft.getInstance().player);
        return vrLeftHanded != (useSwappedHands = ActiveConfig.active().swapBagHand);
    }

    private int getBagControllerNum() {
        return ActiveConfig.active().swapBagHand ? 0 : 1;
    }
}

