/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfoFactory;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractDragImmersive;
import com.hammy275.immersivemc.client.immersive.info.DragImmersiveInfo;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.UsePacket;
import com.hammy275.immersivemc.common.util.Util;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveLever
extends AbstractDragImmersive {
    private static final AbstractDragImmersive.AutoDragSettings settings = new AbstractDragImmersive.AutoDragSettings(List.of(), false);

    @Override
    protected void hitboxDragged(DragImmersiveInfo info, int controller, int oldIndex, int newIndex) {
        Util.useLever((Player)Minecraft.getInstance().player, info.getBlockPosition());
        Network.INSTANCE.sendToServer(new UsePacket(info.getBlockPosition()));
    }

    @Override
    protected AbstractDragImmersive.AutoDragSettings autoDragSettings() {
        return settings;
    }

    @Override
    public void tick(DragImmersiveInfo info) {
        boolean powered = (Boolean)Minecraft.getInstance().level.getBlockState(info.getBlockPosition()).getValue((Property)BlockStateProperties.POWERED);
        info.startingHitboxIndex = powered ? 1 : 0;
        super.tick(info);
    }

    @Override
    public DragImmersiveInfo buildInfo(BlockPos pos, Level level) {
        Direction towardsBaseDir;
        DragImmersiveInfo info = new DragImmersiveInfo(pos);
        BlockState state = level.getBlockState(info.getBlockPosition());
        Vec3 center = Vec3.atCenterOf((Vec3i)info.getBlockPosition());
        AttachFace attachFace = (AttachFace)state.getValue((Property)BlockStateProperties.ATTACH_FACE);
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Direction towardsOnDir = switch (attachFace) {
            case AttachFace.WALL -> {
                towardsBaseDir = facing.getOpposite();
                yield Direction.DOWN;
            }
            case AttachFace.CEILING -> {
                towardsBaseDir = Direction.UP;
                yield facing;
            }
            case AttachFace.FLOOR -> {
                towardsBaseDir = Direction.DOWN;
                yield facing;
            }
            default -> throw new IllegalStateException("Lever is attached to unknown face " + attachFace.getSerializedName());
        };
        Vec3 towardsBase = Vec3.atLowerCornerOf((Vec3i)towardsBaseDir.getNormal());
        Vec3 towardsOn = Vec3.atLowerCornerOf((Vec3i)towardsOnDir.getNormal());
        center = center.add(towardsBase.scale(0.25));
        Vec3 offPos = center.add(towardsOn.scale(-0.25));
        Vec3 onPos = center.add(towardsOn.scale(0.25));
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.ofSize((Vec3)offPos, (double)0.5, (double)0.5, (double)0.5)));
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.ofSize((Vec3)onPos, (double)0.5, (double)0.5, (double)0.5)));
        return info;
    }

    @Override
    public ImmersiveHandler<NullStorage> getHandler() {
        return ImmersiveHandlers.leverHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("lever", () -> new ItemStack((ItemLike)Items.LEVER), config -> config.useLeverImmersive, (config, newVal) -> {
            config.useLeverImmersive = newVal;
        });
    }
}

