/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfoFactory;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractDragImmersive;
import com.hammy275.immersivemc.client.immersive.info.DragImmersiveInfo;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.SetRepeaterPacket;
import com.hammy275.immersivemc.common.util.Util;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveRepeater
extends AbstractDragImmersive {
    private static final AbstractDragImmersive.AutoDragSettings settings = new AbstractDragImmersive.AutoDragSettings(List.of(), false);

    @Override
    protected void hitboxDragged(DragImmersiveInfo info, int controller, int oldIndex, int newIndex) {
        int newDelay = newIndex + 1;
        Util.setRepeater((Level)Minecraft.getInstance().level, info.getBlockPosition(), newDelay);
        Network.INSTANCE.sendToServer(new SetRepeaterPacket(info.getBlockPosition(), newDelay));
    }

    @Override
    protected AbstractDragImmersive.AutoDragSettings autoDragSettings() {
        return settings;
    }

    @Override
    public void tick(DragImmersiveInfo info) {
        BlockState state = Minecraft.getInstance().level.getBlockState(info.getBlockPosition());
        int repeaterValue = (Integer)state.getValue((Property)RepeaterBlock.DELAY);
        info.startingHitboxIndex = repeaterValue - 1;
        super.tick(info);
    }

    @Override
    public ImmersiveHandler<NullStorage> getHandler() {
        return ImmersiveHandlers.repeaterHandler;
    }

    @Override
    protected void makeHitboxes(DragImmersiveInfo info, Level level) {
        BlockState state = Minecraft.getInstance().level.getBlockState(info.getBlockPosition());
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Direction forwardDir = facing.getOpposite();
        Vec3 forward = Vec3.atLowerCornerOf((Vec3i)forwardDir.getNormal());
        Vec3 centerPos = Vec3.upFromBottomCenterOf((Vec3i)info.getBlockPosition(), (double)1.0).add(0.0, -0.675, 0.0);
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.ofSize((Vec3)centerPos.add(forward.multiply(0.0625, 0.0, 0.0625)), (double)0.1428571492433548, (double)0.1428571492433548, (double)0.1428571492433548).inflate(0.0, 0.2, 0.0)));
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.ofSize((Vec3)centerPos.add(forward.multiply(-0.0625, 0.0, -0.0625)), (double)0.1428571492433548, (double)0.1428571492433548, (double)0.1428571492433548).inflate(0.0, 0.2, 0.0)));
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.ofSize((Vec3)centerPos.add(forward.multiply(-0.1875, 0.0, -0.1875)), (double)0.1428571492433548, (double)0.1428571492433548, (double)0.1428571492433548).inflate(0.0, 0.2, 0.0)));
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.ofSize((Vec3)centerPos.add(forward.multiply(-0.3125, 0.0, -0.3125)), (double)0.1428571492433548, (double)0.1428571492433548, (double)0.1428571492433548).inflate(0.0, 0.2, 0.0)));
    }

    @Override
    public DragImmersiveInfo buildInfo(BlockPos pos, Level level) {
        DragImmersiveInfo info = new DragImmersiveInfo(pos);
        this.makeHitboxes(info, level);
        return info;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("repeater", () -> new ItemStack((ItemLike)Items.REPEATER), config -> config.useRepeaterImmersive, (config, newVal) -> {
            config.useRepeaterImmersive = newVal;
        });
    }
}

