/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.book;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.client.immersive.book.BookInteractable;
import com.hammy275.immersivemc.client.immersive.book.BookRenderable;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ClientBookData
extends CommonBookData {
    private static final BookModel bookModel = new BookModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BOOK));
    private static final ResourceLocation writtenBookTexture = ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"nahnotfox_written_book.png");
    public final List<BookInteractable> interactables = new ArrayList<BookInteractable>();
    public final List<BookRenderable> renderables = new ArrayList<BookRenderable>();
    protected final List<OBB> obbs = new ArrayList<OBB>();
    protected float lastLeftPageTurn;
    protected float lastRightPageTurn;

    public ClientBookData() {
        this.pageTurner = Minecraft.getInstance().player;
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
    }

    @Override
    public void tick(PosRot bookPosRot, PosRot ... others) {
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
        super.tick(bookPosRot, others);
        this.obbs.clear();
        BookInteractable[] interacted = new BookInteractable[others.length];
        for (BookInteractable interactable : this.interactables) {
            OBB obb = interactable.getOBB();
            this.obbs.add(obb);
            for (int o = 0; o < others.length; ++o) {
                PosRot other = others[o];
                if (interacted[o] != null || !obb.contains(other.position())) continue;
                interacted[o] = interactable;
            }
        }
        for (int o = 0; o < others.length; ++o) {
            if (interacted[o] == null) continue;
            if (Minecraft.getInstance().options.keyAttack.isDown()) {
                interacted[o].interact(this, bookPosRot, others[o]);
                continue;
            }
            interacted[o].hover(this, bookPosRot, others[o]);
        }
    }

    public void render(PoseStack stack, int light, PosRot bookPosRot) {
        stack.pushPose();
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        Vec3 pos = bookPosRot.position();
        Camera cameraInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        stack.translate(-cameraInfo.getPosition().x + pos.x, -cameraInfo.getPosition().y + pos.y, -cameraInfo.getPosition().z + pos.z);
        stack.scale(1.0f, 1.0f, 1.0f);
        stack.mulPose(Axis.YN.rotationDegrees(bookPosRot.getYaw() + 90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(bookPosRot.getPitch()));
        stack.mulPose(Axis.YN.rotationDegrees(bookPosRot.getRoll()));
        float bookOpenAmount = 1.1f;
        bookModel.setupAnim(0.0f, Mth.lerp((float)partialTick, (float)this.lastLeftPageTurn, (float)this.leftPageTurn), Mth.lerp((float)partialTick, (float)this.lastRightPageTurn, (float)this.rightPageTurn), bookOpenAmount);
        bookModel.render(stack, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entitySolid((ResourceLocation)writtenBookTexture)), light, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
        if (this.pageChangeState == PageChangeState.NONE) {
            this.renderPage(stack, bookPosRot, true, light);
            this.renderPage(stack, bookPosRot, false, light);
        }
        if (this.pageChangeState == PageChangeState.NONE) {
            for (int i = 0; i <= 1; ++i) {
                OBBClientUtil.renderOBB(stack, this.pageTurnBoxes[i], false, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (!this.pageChangeState.isAnim) {
            OBBClientUtil.renderOBB(stack, this.pageTurnBoxes[2], false, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        for (OBB obb : this.obbs) {
            OBBClientUtil.renderOBB(stack, obb, false, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void mergeFromServer(CommonBookData fromServer) {
        this.leftPageIndex = fromServer.leftPageIndex;
        this.leftPageTurn = fromServer.leftPageTurn;
        this.rightPageTurn = fromServer.rightPageTurn;
        this.pageChangeState = fromServer.pageChangeState;
    }

    public List<OBB> getPageTurnHitboxes() {
        return List.of(this.pageTurnBoxes);
    }

    public List<OBB> getInteractableHitboxes() {
        return this.interactables.stream().map(BookInteractable::getOBB).toList();
    }

    protected void renderPage(PoseStack stack, PosRot bookPosRot, boolean leftPage, int light) {
        Vec3 awayFromBookUp = this.getAwayVector(bookPosRot);
        Vec3 pageUp = bookPosRot.getLookAngle();
        Vec3 left = this.getLeftRightVector(bookPosRot, leftPage);
        Vec3 posBase = bookPosRot.position().add(left.scale(0.15)).add(awayFromBookUp.scale(0.09375));
        Camera cameraInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        for (BookRenderable renderable : this.renderables) {
            stack.pushPose();
            Vec3 renderableOffset = renderable.getStartOffset(this, leftPage, bookPosRot);
            Vec3 pos = posBase.add(pageUp.scale(0.25 * renderableOffset.y)).add(left.scale(-0.15 * renderableOffset.x)).add(awayFromBookUp.scale(0.09375 * renderableOffset.z));
            stack.translate(-cameraInfo.getPosition().x + pos.x, -cameraInfo.getPosition().y + pos.y, -cameraInfo.getPosition().z + pos.z);
            stack.mulPose(Axis.YN.rotationDegrees(bookPosRot.getYaw() + 90.0f));
            stack.mulPose(Axis.ZP.rotationDegrees(bookPosRot.getPitch()));
            stack.mulPose(Axis.XP.rotationDegrees(90.0f + (leftPage ? 11.0f : -11.0f)));
            stack.mulPose(Axis.ZP.rotationDegrees(270.0f));
            stack.mulPose(Axis.YP.rotationDegrees(bookPosRot.getRoll()));
            renderable.render(stack, this, leftPage, light, bookPosRot);
            stack.popPose();
        }
    }

    @Override
    public void resetTurnState() {
        super.resetTurnState();
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
    }
}

