/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.book;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.client.immersive.book.BookInteractable;
import com.hammy275.immersivemc.client.immersive.book.BookRenderable;
import com.hammy275.immersivemc.client.immersive.book.ClientBookData;
import com.hammy275.immersivemc.client.immersive.book.WrittenBookDataHolder;
import com.hammy275.immersivemc.client.workaround.ClickHandlerScreen;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class WrittenBookHelpers {
    public static ClientBookData makeClientBookData(WrittenBookDataHolder dataHolder) {
        ClientBookData bookData = new ClientBookData();
        BookViewScreen.BookAccess access = BookViewScreen.BookAccess.fromItem((ItemStack)dataHolder.getBook());
        bookData.renderables.add(new BookTextRenderer(isLeftPage -> {
            int rightMod = isLeftPage != false ? 0 : 1;
            return access.getPage(dataHolder.getData().getLeftPageIndex() + rightMod);
        }, -0.0025f, new Vec3(0.0, 1.0, 0.0)));
        bookData.setMaxLeftPageIndex(Math.max(access.getPageCount() - 1, 0));
        return bookData;
    }

    public static void addInteractablesForThisTick(WrittenBookDataHolder dataHolder, PosRot bookPosRot, boolean isLeft) {
        if (dataHolder.getData().getPageChangeState() != PageChangeState.NONE) {
            return;
        }
        BookViewScreen.BookAccess access = BookViewScreen.BookAccess.fromItem((ItemStack)dataHolder.getBook());
        if (access == null) {
            return;
        }
        ClientBookData data = dataHolder.getData();
        Vec3 pageUp = bookPosRot.getLookAngle();
        Vec3 pageDown = pageUp.scale(-1.0);
        Vec3 left = data.getLeftRightVector(bookPosRot, true);
        Vec3 right = data.getLeftRightVector(bookPosRot, false);
        Vec3 away = data.getAwayVector(bookPosRot);
        Vec3 leftStartMove = isLeft ? left.scale(0.288) : Vec3.ZERO;
        Vec3 pos = bookPosRot.position().add(pageUp.scale(0.25)).add(leftStartMove).add(away.scale(0.09375)).add(pageDown.scale((double)(9.0f * Math.abs(-0.0025f))));
        Font font = Minecraft.getInstance().font;
        int rightMod = isLeft ? 0 : 1;
        FormattedText rawText = access.getPage(dataHolder.getData().getLeftPageIndex() + rightMod);
        List text = font.split(rawText, 114);
        for (int lineNum = 0; lineNum < text.size(); ++lineNum) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            Vec3 leftPos = pos.add(pageDown.scale((double)((float)(26 + lineNum * 9) * Math.abs(-0.0025f))));
            ArrayList chars = new ArrayList();
            ((FormattedCharSequence)text.get(lineNum)).accept((charIndex, style, codePoint) -> {
                chars.add(new Pair((Object)new StringBuilder().appendCodePoint(codePoint).toString(), (Object)style));
                return true;
            });
            double pixelsMoved = 0.0;
            Style styleForPositions = null;
            ArrayList<Vec3> stylePositions = new ArrayList<Vec3>();
            double length = 0.0;
            for (Pair c : chars) {
                String str = (String)c.getFirst();
                Style style2 = (Style)c.getSecond();
                pixelsMoved += (double)font.width(str) / 2.0;
                double halfCharWidth = (double)font.width(str) / 2.0 * (double)Math.abs(-0.0025f);
                leftPos = leftPos.add(right.scale(halfCharWidth));
                if (style2.getClickEvent() != null) {
                    Vec3 placePos;
                    double pixelMovedRatio = pixelsMoved / 114.0;
                    if (pixelMovedRatio < 0.5 && isLeft || pixelMovedRatio > 0.5 && !isLeft) {
                        pixelMovedRatio = pixelMovedRatio > 0.5 ? (pixelMovedRatio -= 0.5) : 0.5 - pixelMovedRatio;
                        placePos = leftPos.add(away.scale(0.09375).scale(pixelMovedRatio / 2.0));
                    } else {
                        pixelMovedRatio = pixelMovedRatio > 0.5 ? (pixelMovedRatio -= 0.5) : 0.5 - pixelMovedRatio;
                        placePos = leftPos.add(away.scale(0.09375).scale(-pixelMovedRatio / 2.0));
                    }
                    if (style2 != styleForPositions) {
                        BookInteractable interactable = WrittenBookHelpers.makeInteractable(dataHolder, stylePositions, styleForPositions, length, bookPosRot, isLeft);
                        if (interactable != null) {
                            data.interactables.add(interactable);
                        }
                        styleForPositions = style2;
                        stylePositions.clear();
                    } else {
                        stylePositions.add(placePos);
                        length += halfCharWidth * 2.0;
                    }
                }
                pixelsMoved += (double)font.width(str) / 2.0;
                leftPos = leftPos.add(right.scale(halfCharWidth));
            }
            BookInteractable interactable = WrittenBookHelpers.makeInteractable(dataHolder, stylePositions, styleForPositions, length, bookPosRot, isLeft);
            if (interactable == null) continue;
            data.interactables.add(interactable);
        }
    }

    @Nullable
    private static BookInteractable makeInteractable(WrittenBookDataHolder holder, List<Vec3> positions, Style style, double length, PosRot hand, boolean isLeft) {
        if (style != null && style.getClickEvent() != null && !positions.isEmpty()) {
            Vec3 centerPos = WrittenBookHelpers.getCenterPos(positions);
            return new BookStyleInteractable(holder, OBBFactory.instance().create(AABB.ofSize((Vec3)centerPos, (double)length, (double)0.04, (double)0.02), Math.toRadians(hand.getPitch()), Math.toRadians(hand.getYaw()), (isLeft ? CommonBookData.leftPageRot : -CommonBookData.leftPageRot) + Math.toRadians(hand.getRoll())), style);
        }
        return null;
    }

    private static Vec3 getCenterPos(List<Vec3> positions) {
        int size = positions.size();
        if (size % 2 == 0) {
            Vec3 a = positions.get(size / 2);
            Vec3 b = positions.get(size / 2 - 1);
            return a.add(b).scale(0.5);
        }
        return positions.get(size / 2);
    }

    public record BookTextRenderer(Function<Boolean, FormattedText> textSupplier, float textStackScaleSize, Vec3 offset) implements BookRenderable
    {
        @Override
        public void render(PoseStack stack, ClientBookData data, boolean leftPage, int light, PosRot bookPosRot) {
            stack.scale(this.textStackScaleSize, this.textStackScaleSize, this.textStackScaleSize);
            Font font = Minecraft.getInstance().font;
            FormattedText textRaw = this.textSupplier.apply(leftPage);
            if (textRaw == null) {
                return;
            }
            List text = font.split(textRaw, 114);
            int lineNum = 0;
            for (FormattedCharSequence seq : text) {
                font.drawInBatch(seq, -56.0f, (float)(32 + lineNum++ * 9), -16777216, false, stack.last().pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, light);
            }
        }

        @Override
        public Vec3 getStartOffset(ClientBookData data, boolean leftPage, PosRot bookPosRot) {
            return this.offset;
        }
    }

    private record BookStyleInteractable(WrittenBookDataHolder holder, OBB obb, Style style) implements BookInteractable
    {
        @Override
        public OBB getOBB() {
            return this.obb;
        }

        @Override
        public void hover(ClientBookData data, PosRot bookPosRot, PosRot other) {
            Vec3 pos = this.obb.getCenter();
            Minecraft.getInstance().player.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 1.0f), 0.2f), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }

        @Override
        public void interact(ClientBookData data, PosRot bookPosRot, PosRot other) {
            ClickEvent clickEvent = this.style.getClickEvent();
            if (clickEvent != null) {
                String eventValue = clickEvent.getValue();
                if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
                    try {
                        int newPageNum = Integer.parseInt(eventValue) - 1;
                        data.setPage(newPageNum);
                        this.holder.onPageChangeStyleClick(newPageNum);
                    }
                    catch (Exception newPageNum) {}
                } else {
                    ClickHandlerScreen tempScreen = new ClickHandlerScreen();
                    Minecraft.getInstance().setScreen((Screen)tempScreen);
                    tempScreen.handleComponentClicked(this.style);
                }
            }
        }
    }
}

