/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.RelativeHitboxInfoImpl;
import com.hammy275.immersivemc.client.immersive.SwapTracker;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public final class BuiltImmersiveInfoImpl<E>
implements BuiltImmersiveInfo<E> {
    public final List<RelativeHitboxInfoImpl> hitboxes;
    public final List<HitboxInfo> hitboxesOut;
    private final BlockPos pos;
    public final E extraData;
    public Direction immersiveDir = null;
    public boolean airCheckPassed = false;
    public int[] slotsHovered = new int[]{-1, -1};
    public int light = ClientUtil.maxLight;
    public long ticksExisted = 0L;
    public AABB dragHitbox = null;

    public BuiltImmersiveInfoImpl(List<RelativeHitboxInfoImpl> hitboxes, BlockPos pos, Class<E> extraDataClazz) {
        this.hitboxes = new ArrayList<RelativeHitboxInfoImpl>(hitboxes.size());
        this.hitboxesOut = new ArrayList<HitboxInfo>(hitboxes.size());
        for (RelativeHitboxInfoImpl hitbox : hitboxes) {
            RelativeHitboxInfoImpl clone = (RelativeHitboxInfoImpl)hitbox.clone();
            this.hitboxes.add(clone);
            this.hitboxesOut.add(clone);
        }
        this.pos = pos;
        try {
            this.extraData = extraDataClazz == null ? null : extraDataClazz.getDeclaredConstructor(null).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public List<HitboxInfo> getAllHitboxes() {
        return this.hitboxesOut;
    }

    @Override
    public boolean hasHitboxes() {
        for (RelativeHitboxInfoImpl hitbox : this.hitboxes) {
            if (!hitbox.hasAABB()) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.pos;
    }

    @Override
    public void setSlotHovered(int hitboxIndex, int handIndex) {
        this.slotsHovered[handIndex] = hitboxIndex;
    }

    @Override
    public int getSlotHovered(int handIndex) {
        return this.slotsHovered[handIndex];
    }

    @Override
    public boolean isSlotHovered(int hitboxIndex) {
        return this.slotsHovered[0] == hitboxIndex || this.slotsHovered[1] == hitboxIndex || SwapTracker.slotHovered(this, hitboxIndex);
    }

    @Override
    public long getTicksExisted() {
        return this.ticksExisted;
    }

    @Override
    public E getExtraData() {
        return this.extraData;
    }

    @Override
    public ItemStack getItem(int hitboxIndex) {
        ItemStack item = this.hitboxes.get((int)hitboxIndex).item;
        return item == null ? ItemStack.EMPTY : item;
    }

    @Override
    public void setFakeItem(int hitboxIndex, ItemStack item) {
        this.hitboxes.get((int)hitboxIndex).item = item;
    }

    @Override
    public long ticksExisted() {
        return this.ticksExisted;
    }
}

