/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.book.BookRenderable;
import com.hammy275.immersivemc.client.immersive.book.ClientBookData;
import com.hammy275.immersivemc.client.immersive.book.WrittenBookHelpers;
import com.hammy275.immersivemc.common.compat.apotheosis.Apoth;
import com.hammy275.immersivemc.common.compat.apotheosis.ApothStats;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ETableStorage;
import com.hammy275.immersivemc.common.util.PosRot;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class EnchantingData {
    public final ETableData weakData = new ETableData();
    public final ETableData midData = new ETableData();
    public final ETableData strongData = new ETableData();
    public ApothStats apothStats = ApothStats.EMPTY;
    protected ClientBookData bookData = null;

    public boolean hasAnyEnchantments() {
        return this.strongData.isPresent() || this.midData.isPresent() || this.weakData.isPresent();
    }

    @Nullable
    public ClientBookData getBookData(BuiltImmersiveInfo<EnchantingData> info) {
        if (this.bookData == null && Apoth.apothImpl.enchantModuleEnabled()) {
            this.bookData = new ClientBookData();
            this.bookData.renderables.add(new WrittenBookHelpers.BookTextRenderer(leftPage -> {
                if (leftPage.booleanValue()) {
                    boolean hasItem = !info.getItem(0).isEmpty();
                    return FormattedText.composite((FormattedText[])new FormattedText[]{Component.literal((String)"\n"), this.translate("gui.apothic_enchanting.enchant.eterna").withStyle(ChatFormatting.GREEN), Component.literal((String)"\n"), this.makeStatComponent(this.apothStats.eterna(), 100.0f, hasItem, false).withStyle(ChatFormatting.GREEN), Component.literal((String)"\n\n"), this.translate("gui.apothic_enchanting.enchant.quanta").withStyle(ChatFormatting.RED), Component.literal((String)"\n"), this.makeStatComponent(this.apothStats.quanta(), 100.0f, hasItem, true).withStyle(ChatFormatting.RED), Component.literal((String)"\n\n"), this.translate("gui.apothic_enchanting.enchant.arcana").withStyle(ChatFormatting.DARK_PURPLE), Component.literal((String)"\n"), this.makeStatComponent(this.apothStats.arcana(), 100.0f, hasItem, true).withStyle(ChatFormatting.DARK_PURPLE)});
                }
                return Component.EMPTY;
            }, -0.00375f, new Vec3(0.45, 1.3333333333333333, 0.0)));
            this.bookData.renderables.add(new ApothBarBookRenderable(() -> Float.valueOf(this.apothStats.eterna() / 100.0f), new Vec3(1.0, 0.5, 0.0), 0.0f, 197.0f, false, info));
            this.bookData.renderables.add(new ApothBarBookRenderable(() -> Float.valueOf(this.apothStats.quanta() / 100.0f), new Vec3(1.0, 0.1, 0.0), 5.0f, 202.0f, false, info));
            this.bookData.renderables.add(new ApothBarBookRenderable(() -> Float.valueOf(this.apothStats.arcana() / 100.0f), new Vec3(1.0, -0.3, 0.0), 10.0f, 207.0f, false, info));
        } else if (this.bookData != null && !Apoth.apothImpl.enchantModuleEnabled()) {
            this.bookData = null;
        }
        return this.bookData;
    }

    private MutableComponent translate(String key) {
        if (Platform.isModLoaded("zenith")) {
            return Component.translatable((String)key.replaceFirst("apothic_enchanting", "zenith"));
        }
        return Component.translatable((String)key);
    }

    private MutableComponent makeStatComponent(float stat, float max, boolean hasItem, boolean isPercent) {
        String end;
        String string = end = isPercent ? "%" : "";
        if (!hasItem) {
            return Component.literal((String)"??.??%s/??.??%s".formatted(end, end)).withStyle(ChatFormatting.OBFUSCATED);
        }
        return Component.literal((String)"%.2f%s/%.2f%s".formatted(Float.valueOf(stat), end, Float.valueOf(max), end));
    }

    public static class ETableData {
        public int levelsNeeded;
        public List<Component> textPreviews = new ArrayList<Component>();

        public boolean isPresent() {
            return this.levelsNeeded > -1;
        }

        public void set(ETableStorage.SlotData data) {
            this.textPreviews.clear();
            if (data.enchantmentHints().isEmpty()) {
                this.textPreviews.add((Component)Component.literal((String)"???"));
            } else {
                for (int i = 0; i < data.enchantmentHints().size(); ++i) {
                    Registry enchantments = (Registry)Minecraft.getInstance().level.registryAccess().registry(Registries.ENCHANTMENT).get();
                    Enchantment ench = (Enchantment)enchantments.byId(data.enchantmentHints().get(i).intValue());
                    if (ench == null) {
                        this.levelsNeeded = -1;
                        break;
                    }
                    this.levelsNeeded = data.xpLevel();
                    String end = i == data.enchantmentHints().size() - 1 ? "...?" : "";
                    this.textPreviews.add((Component)Component.literal((String)(Enchantment.getFullname((Holder)enchantments.wrapAsHolder((Object)ench), (int)data.enchantmentHintLevels().get(i)).getString() + end)));
                }
            }
        }
    }

    private record ApothBarBookRenderable(Supplier<Float> amountFullSupplier, Vec3 offset, float startYEmpty, float startYFull, boolean useOurImageForFull, BuiltImmersiveInfo<EnchantingData> info) implements BookRenderable
    {
        private static ResourceLocation fullLocation = null;
        private static final ResourceLocation emptyLocation = ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"apoth_bars.png");
        private static final float barMaxX = 109.0f;
        private static final float maxXY = 255.0f;

        @Override
        public void render(PoseStack stack, ClientBookData data, boolean leftPage, int light, PosRot bookPosRot) {
            if (leftPage || this.info.getItem(0).isEmpty()) {
                return;
            }
            if (fullLocation == null) {
                String modId = Platform.isModLoaded("zenith") ? "zenith" : "apothic_enchanting";
                fullLocation = ResourceLocation.fromNamespaceAndPath((String)modId, (String)"textures/gui/enchanting_table.png");
            }
            this.renderBar(stack, light, this.amountFullSupplier.get().floatValue());
        }

        private void renderBar(PoseStack stack, int light, float fullAmount) {
            stack.pushPose();
            stack.mulPose(Axis.YP.rotation((float)Math.PI));
            float size = 0.0022935779f;
            stack.scale(size, size, size);
            this.renderBarPart(false, stack, light, 0.0f, this.startYFull, fullAmount);
            this.renderBarPart(true, stack, light, 109.0f * fullAmount, this.startYEmpty, fullAmount);
            stack.popPose();
        }

        private void renderBarPart(boolean isEmpty, PoseStack stack, int light, float startX, float startY, float fullAmount) {
            if (!isEmpty && fullAmount <= 0.0f || isEmpty && 1.0f - fullAmount <= 0.0f) {
                return;
            }
            ResourceLocation barLoc = !isEmpty && !this.useOurImageForFull ? fullLocation : emptyLocation;
            VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)barLoc));
            PoseStack.Pose lastPose = stack.last();
            Matrix4f pose = lastPose.pose();
            float minImageU = startX / 255.0f;
            float maxImageU = (startX + 109.0f * (isEmpty ? 1.0f - fullAmount : fullAmount)) / 255.0f;
            float minImageV = startY / 255.0f;
            float maxImageV = (startY + 4.0f) / 255.0f;
            float minX = isEmpty ? 109.0f * fullAmount : 0.0f;
            float minY = 0.0f;
            float maxX = isEmpty ? 109.0f : 109.0f * fullAmount;
            float maxY = 16.0f;
            consumer.addVertex(pose, minX, minY, 0.0f).setColor(255, 255, 255, 255).setUv(minImageU, maxImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose, maxX, minY, 0.0f).setColor(255, 255, 255, 255).setUv(maxImageU, maxImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose, maxX, maxY, 0.0f).setColor(255, 255, 255, 255).setUv(maxImageU, minImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose, minX, maxY, 0.0f).setColor(255, 255, 255, 255).setUv(minImageU, minImageV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        }

        @Override
        public Vec3 getStartOffset(ClientBookData data, boolean leftPage, PosRot bookPosRot) {
            return this.offset;
        }
    }
}

