/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GrindstoneData {
    private static final int TICKS_TO_GRIND = 10;
    public final GrindHand[] grindHands = new GrindHand[]{new GrindHand(), new GrindHand()};

    public boolean didGrind(InteractionHand hand) {
        return this.grindHands[hand.ordinal()].didGrind();
    }

    public void resetGrind(InteractionHand hand) {
        this.grindHands[hand.ordinal()].resetGrind();
    }

    public boolean grindTick(InteractionHand hand) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty()) {
            GrindstoneMenu menu = new GrindstoneMenu(-1, player.getInventory());
            if (((Slot)menu.slots.get(0)).mayPlace(stack)) {
                ((Slot)menu.slots.get(0)).set(stack);
                if (!((Slot)menu.slots.get(2)).getItem().isEmpty()) {
                    this.grindHands[hand.ordinal()].grindTick();
                    return true;
                }
            }
        }
        return false;
    }

    public static class GrindHand {
        public int startTick;
        public int lastTick;

        private GrindHand() {
            this.resetGrind();
        }

        public boolean didGrind() {
            return this.lastTick - this.startTick >= 10 && this.startTick >= 0;
        }

        public void resetGrind() {
            this.startTick = -1;
            this.lastTick = -1;
        }

        public void grindTick() {
            int currentTick = Minecraft.getInstance().player.tickCount;
            if (currentTick - 1 == this.lastTick || currentTick - 2 == this.lastTick) {
                ++this.lastTick;
            } else {
                this.startTick = currentTick;
                this.lastTick = currentTick;
            }
        }
    }
}

