/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.ClientUtil;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HitboxItemPair
implements HitboxInfo {
    @Nullable
    public BoundingBox box;
    public ItemStack item;
    public boolean isTriggerHitbox;
    @Nullable
    public Vec3 lastPos = null;

    public HitboxItemPair(@Nullable BoundingBox box, ItemStack item, boolean isTriggerHitbox) {
        this.box = box;
        this.item = Objects.requireNonNull(item);
        this.isTriggerHitbox = isTriggerHitbox;
    }

    public HitboxItemPair(@Nullable BoundingBox box, boolean isTriggerHitbox) {
        this(box, ItemStack.EMPTY, isTriggerHitbox);
    }

    @Override
    @Nullable
    public BoundingBox getHitbox() {
        return this.box;
    }

    @Override
    public boolean isTriggerHitbox() {
        return this.isTriggerHitbox;
    }

    @Override
    public BoundingBox getRenderHitbox(float partialTick) {
        if (this.box == null || this.lastPos == null) {
            return this.box;
        }
        return BoundingBox.move(this.box, ClientUtil.lerpVec3(this.lastPos, BoundingBox.getCenter(this.box), partialTick).subtract(this.lastPos));
    }
}

