/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.subscribe;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive_item.AbstractHandImmersive;
import com.hammy275.immersivemc.client.immersive_item.HandImmersives;
import com.hammy275.immersivemc.client.model.Cube1x1;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ItemGuideColorData;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.util.RGBA;
import com.hammy275.immersivemc.common.util.ShieldUtil;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Instant;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ClientRenderSubscriber {
    public static final Cube1x1 cubeModel = new Cube1x1(Minecraft.getInstance().getEntityModels().bakeLayer(Cube1x1.LAYER_LOCATION));
    public static final List<ItemGuideRenderData> itemGuideRenderData = new ArrayList<ItemGuideRenderData>(128);
    private static long lastMillis;
    private static RGBA itemGuideColor;
    private static float cycleProgress;
    private static RGBA itemGuideSelectedColor;
    private static float cycleProgressSelected;
    private static RGBA rangedGrabColor;
    private static float cycleProgressRangedGrab;

    public static void onWorldRender(PoseStack stack) {
        ClientRenderSubscriber.setRenderColors();
        try {
            for (Immersive immersive : Immersives.IMMERSIVES) {
                ClientRenderSubscriber.renderInfos(immersive, stack);
            }
            for (AbstractPlayerAttachmentImmersive abstractPlayerAttachmentImmersive : Immersives.IMMERSIVE_ATTACHMENTS) {
                ClientRenderSubscriber.renderInfos(abstractPlayerAttachmentImmersive, stack);
            }
            if (VRPluginVerify.clientInVR()) {
                for (AbstractHandImmersive abstractHandImmersive : HandImmersives.HAND_IMMERSIVES) {
                    abstractHandImmersive.renderAll(stack);
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        if (VRPluginVerify.clientInVR()) {
            for (InteractionHand iHand : InteractionHand.values()) {
                if (Minecraft.getInstance().player.getItemInHand(iHand).getUseAnimation() != UseAnim.BLOCK) continue;
                IVRPlayer vrPlayer = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.getInstance().player) : VRPlugin.API.getRenderVRPlayer();
                IVRData hand = vrPlayer.getController(iHand.ordinal());
                ImmersiveRenderHelpers.instance().renderHitbox(stack, ShieldUtil.getShieldHitbox((Player)Minecraft.getInstance().player, hand, iHand), false, 1.0f, 1.0f, 1.0f);
            }
        }
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
        for (ItemGuideRenderData itemGuideRenderData : ClientRenderSubscriber.itemGuideRenderData) {
            ClientRenderSubscriber.renderItemGuide(itemGuideRenderData.stack, itemGuideRenderData.hitbox, itemGuideRenderData.alpha, itemGuideRenderData.isSelected, itemGuideRenderData.light);
        }
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
        itemGuideRenderData.clear();
    }

    public static void setRenderColors() {
        if (lastMillis == 0L) {
            lastMillis = Instant.now().toEpochMilli();
        }
        ItemGuideColorData colorData = ActiveConfig.FILE_CLIENT.itemGuidePreset.colorData.get();
        long now = Instant.now().toEpochMilli();
        long timeDiff = now - lastMillis;
        int transitionTimeMS = colorData.transitionTimeMS().get();
        if (colorData.colors().get().size() > 1) {
            cycleProgress = (cycleProgress + (float)timeDiff / (float)((long)transitionTimeMS * (long)colorData.colors().get().size())) % 1.0f;
        }
        if (colorData.selectedColors().get().size() > 1) {
            cycleProgressSelected = (cycleProgressSelected + (float)timeDiff / (float)((long)transitionTimeMS * (long)colorData.selectedColors().get().size())) % 1.0f;
        }
        if (colorData.rangedGrabColors().get().size() > 1) {
            cycleProgressRangedGrab = (cycleProgressRangedGrab + (float)timeDiff / (float)((long)transitionTimeMS * (long)colorData.rangedGrabColors().get().size())) % 1.0f;
        }
        itemGuideColor = ClientRenderSubscriber.updateColor(colorData.colors().get(), cycleProgress);
        itemGuideSelectedColor = ClientRenderSubscriber.updateColor(colorData.selectedColors().get(), cycleProgressSelected);
        rangedGrabColor = ClientRenderSubscriber.updateColor(colorData.rangedGrabColors().get(), cycleProgressRangedGrab);
        lastMillis = now;
    }

    public static void resetCycleProgresses() {
        cycleProgress = 0.0f;
        cycleProgressSelected = 0.0f;
        cycleProgressRangedGrab = 0.0f;
    }

    protected static <I extends ImmersiveInfo> void renderInfos(Immersive<I, ?> singleton, PoseStack stack) {
        try {
            if (singleton.isVROnly() && !VRPluginVerify.clientInVR()) {
                return;
            }
            for (ImmersiveInfo info : singleton.getTrackedObjects()) {
                if (!singleton.shouldRender(info)) continue;
                singleton.render(info, stack, ImmersiveRenderHelpers.instance(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    protected static <I extends AbstractPlayerAttachmentInfo> void renderInfos(AbstractPlayerAttachmentImmersive<I, ?> singleton, PoseStack stack) {
        try {
            if (singleton.isVROnly() && !VRPluginVerify.clientInVR()) {
                return;
            }
            for (AbstractPlayerAttachmentInfo info : singleton.getTrackedObjects()) {
                singleton.doRender(info, stack, VRPluginVerify.clientInVR());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private static void renderItemGuide(PoseStack stack, BoundingBox hitbox, float alpha, boolean isSelected, int light) {
        if (hitbox != null && !Minecraft.getInstance().options.hideGui) {
            RGBA color = isSelected ? ClientRenderSubscriber.itemGuideSelectedColor() : ClientRenderSubscriber.itemGuideColor();
            AABB aabb = hitbox.isAABB() ? hitbox.asAABB() : hitbox.asOBB().getUnderlyingAABB();
            float size = (float)aabb.getSize() * (isSelected ? (float)ActiveConfig.active().itemGuideSelectedSize : (float)ActiveConfig.active().itemGuideSize);
            if (ActiveConfig.active().placementGuideMode == PlacementGuideMode.CUBE) {
                Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
                Vec3 pos = aabb.getCenter();
                stack.pushPose();
                stack.translate(-renderInfo.getPosition().x + pos.x, -renderInfo.getPosition().y + pos.y, -renderInfo.getPosition().z + pos.z);
                MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                if (hitbox.isOBB()) {
                    OBBClientUtil.rotateStackForOBB(stack, hitbox.asOBB());
                }
                cubeModel.render(stack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)Cube1x1.textureLocation)), (int)color.toLong(), size / 2.0f, light);
                stack.popPose();
            } else if (ActiveConfig.active().placementGuideMode == PlacementGuideMode.OUTLINE) {
                if (hitbox.isAABB()) {
                    ImmersiveRenderHelpers.instance().renderHitbox(stack, (BoundingBox)AABB.ofSize((Vec3)aabb.getCenter(), (double)size, (double)size, (double)size), true, color.redF(), color.greenF(), color.blueF(), color.alphaF());
                } else {
                    OBBClientUtil.renderOBB(stack, hitbox.asOBB(), true, color.redF(), color.greenF(), color.blueF(), color.alphaF());
                }
            }
        }
    }

    public static RGBA itemGuideColor() {
        return itemGuideColor;
    }

    public static RGBA itemGuideSelectedColor() {
        return itemGuideSelectedColor;
    }

    public static RGBA rangedGrabColor() {
        return rangedGrabColor;
    }

    private static RGBA updateColor(List<RGBA> colors, float cycleProgress) {
        if (colors.size() == 1) {
            return colors.get(0);
        }
        float progressPerColor = 1.0f / (float)colors.size();
        int startIndex = (int)(cycleProgress / progressPerColor);
        int endIndex = startIndex + 1;
        if (endIndex == colors.size()) {
            endIndex = 0;
        }
        RGBA start = colors.get(startIndex);
        RGBA end = colors.get(endIndex);
        float transitionProgress = cycleProgress % progressPerColor / progressPerColor;
        return new RGBA(ClientRenderSubscriber.avgColorTransition(start, end, 'r', transitionProgress), ClientRenderSubscriber.avgColorTransition(start, end, 'g', transitionProgress), ClientRenderSubscriber.avgColorTransition(start, end, 'b', transitionProgress), ClientRenderSubscriber.avgColorTransition(start, end, 'a', transitionProgress));
    }

    private static int avgColorTransition(RGBA start, RGBA end, char c, float transitionProgress) {
        return (int)((float)start.getColor(c) * (1.0f - transitionProgress) + (float)end.getColor(c) * transitionProgress);
    }

    public record ItemGuideRenderData(PoseStack stack, BoundingBox hitbox, float alpha, boolean isSelected, int light) {
    }
}

