/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.tracker;

import com.hammy275.immersivemc.ImmersiveMC;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.client.tracker.ClientTrackerInit;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.GrabItemPacket;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.util.RGBA;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class RangedGrabTrackerClient
extends AbstractTracker {
    public static final double threshold = 0.1;
    protected IVRData last = null;
    protected ItemEntity selected = null;
    protected int cooldown = 0;

    public RangedGrabTrackerClient() {
        ClientTrackerInit.trackers.add(this);
    }

    @Override
    protected void tick(Player player) {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        IVRData controller = vrPlayer.getController0();
        if (this.cooldown <= 0) {
            double dist;
            double d = dist = ActiveConfig.active().rangedGrabRange == -1 ? Minecraft.getInstance().player.blockInteractionRange() : (double)ActiveConfig.active().rangedGrabRange;
            if (this.last != null) {
                if (Minecraft.getInstance().options.keyAttack.isDown() || ImmersiveMC.RANGED_GRAB_KEY.isDown()) {
                    boolean grabFromMove = controller.position().y - this.last.position().y > 0.1 && Minecraft.getInstance().options.keyAttack.isDown();
                    boolean grabFromKey = ImmersiveMC.RANGED_GRAB_KEY.isDown();
                    if ((grabFromKey || grabFromMove) && this.selected != null) {
                        Network.INSTANCE.sendToServer(new GrabItemPacket(this.selected));
                        this.selected = null;
                    }
                } else {
                    this.selected = null;
                    Vec3 start = controller.position();
                    Vec3 viewVec = controller.getLookAngle();
                    Vec3 end = start.add(viewVec.x * dist, viewVec.y * dist, viewVec.z * dist);
                    List ents = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(10.0), entity -> entity instanceof ItemEntity && Util.canPickUpItem((ItemEntity)entity, player));
                    LinkedList<AABB> hitboxes = new LinkedList<AABB>();
                    for (Entity ent : ents) {
                        hitboxes.add(ent.getBoundingBox().inflate(0.3333333333333333));
                    }
                    Optional<Integer> result = Util.rayTraceClosest(start, end, (BoundingBox[])hitboxes.toArray(new AABB[0]));
                    if (result.isPresent()) {
                        this.selected = (ItemEntity)ents.get(result.get());
                    }
                }
            }
            if (this.selected != null) {
                RGBA color = ClientRenderSubscriber.rangedGrabColor();
                Vec3 pos = this.selected.position().add(0.0, 0.2, 0.0);
                this.selected.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(color.redF(), color.greenF(), color.blueF()), color.alphaF()), pos.x, pos.y, pos.z, 0.01, 0.01, 0.01);
            }
        }
        this.last = controller;
    }

    @Override
    protected boolean shouldTick(Player player) {
        return VRPluginVerify.clientInVR() && Minecraft.getInstance().gameMode != null && ActiveConfig.active().useRangedGrabImmersive && VRPlugin.API.apiActive(player);
    }
}

