/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.workaround;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class ClickHandlerScreen
extends Screen {
    private boolean closeWhenAble = false;

    public ClickHandlerScreen() {
        super((Component)Component.empty());
    }

    public boolean handleComponentClicked(@Nullable Style style) {
        boolean ret = super.handleComponentClicked(style);
        if (style != null && style.getClickEvent() != null) {
            ClickEvent.Action action = style.getClickEvent().getAction();
            if (action == ClickEvent.Action.RUN_COMMAND || action == ClickEvent.Action.COPY_TO_CLIPBOARD || action == ClickEvent.Action.SUGGEST_COMMAND) {
                Minecraft.getInstance().setScreen(null);
            } else if (action == ClickEvent.Action.OPEN_URL) {
                this.closeWhenAble = true;
            }
        }
        return ret;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.closeWhenAble) {
            Minecraft.getInstance().setScreen(null);
        }
    }
}

