/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CommonBookData
implements NetworkStorage {
    public static final float scaleSize = 1.0f;
    public static final double singlePageWidth = 0.3;
    public static final double pageHalfHeight = 0.25;
    public static final float textStackScaleSize = -0.0025f;
    public static final double textUpAmount = 0.09375;
    public static final double textInteractDistanceSqr = 0.012656249999999997;
    public static final float pageTilt = 11.0f;
    public static final int linesPerPage = 14;
    public static final int pixelsPerLine = 114;
    public static final double leftPageRot = Math.toRadians(15.0);
    public Consumer<CommonBookData> startVRPageTurnCallback = null;
    public Consumer<Integer> onSetPageCallback = null;
    protected int maxLeftPageIndex = 0;
    protected boolean isDirty = false;
    protected OBB[] pageTurnBoxes = new OBB[3];
    protected Vec3[] pageTurnPositions = new Vec3[3];
    public Player pageTurner;
    protected int pageTurnerHandIndex = -1;
    public int leftPageIndex = 0;
    public float leftPageTurn = 0.0f;
    public float rightPageTurn = 1.0f;
    public PageChangeState pageChangeState = PageChangeState.NONE;

    public void tick(PosRot bookPosRot, PosRot ... others) {
        if (this.maxLeftPageIndex < 0) {
            return;
        }
        Vec3 left = this.getLeftRightVector(bookPosRot, true);
        Vec3 right = this.getLeftRightVector(bookPosRot, false);
        Vec3 away = this.getAwayVector(bookPosRot);
        this.pageTurnPositions[2] = bookPosRot.position().add(away.scale(0.09375));
        this.pageTurnPositions[0] = this.pageTurnPositions[2].add(left.scale(0.375));
        this.pageTurnPositions[1] = this.pageTurnPositions[2].add(right.scale(0.375));
        Vec3 upCenter = this.pageTurnPositions[2].add(away.scale(0.15));
        double pitch = Math.toRadians(bookPosRot.getPitch());
        double yaw = Math.toRadians(bookPosRot.getYaw());
        this.pageTurnBoxes[0] = OBBFactory.instance().create(AABB.ofSize((Vec3)this.pageTurnPositions[0], (double)0.2, (double)0.2, (double)0.5), pitch, yaw, Math.toRadians(bookPosRot.getRoll()));
        this.pageTurnBoxes[1] = OBBFactory.instance().create(AABB.ofSize((Vec3)this.pageTurnPositions[1], (double)0.2, (double)0.2, (double)0.5), pitch, yaw, Math.toRadians(bookPosRot.getRoll()));
        this.pageTurnBoxes[2] = OBBFactory.instance().create(AABB.ofSize((Vec3)upCenter, (double)1.0999999999999999, (double)0.6, (double)0.5625), pitch, yaw, Math.toRadians(bookPosRot.getRoll()));
        if (this.pageChangeState == PageChangeState.LEFT_TO_RIGHT_ANIM) {
            this.leftPageTurn = Math.min(this.leftPageTurn + 0.05f, 1.0f);
            if (this.leftPageTurn == 1.0f) {
                this.resetTurnState();
                return;
            }
        } else if (this.pageChangeState == PageChangeState.RIGHT_TO_LEFT_ANIM) {
            this.rightPageTurn = Math.max(this.rightPageTurn - 0.05f, 0.0f);
            if (this.rightPageTurn == 0.0f) {
                this.resetTurnState();
                return;
            }
        }
        boolean someHandPageTurning = false;
        int start = this.pageTurnerHandIndex == -1 ? 0 : this.pageTurnerHandIndex;
        int end = this.pageTurnerHandIndex == -1 ? others.length : this.pageTurnerHandIndex + 1;
        for (int i = start; i < end; ++i) {
            PosRot other = others[i];
            if (this.pageChangeState == PageChangeState.NONE) {
                if (this.pageTurnBoxes[0].contains(other.position()) && !this.onFirstPage()) {
                    someHandPageTurning = true;
                    this.startVRPageTurn(PageChangeState.LEFT_TO_RIGHT, i);
                } else if (this.pageTurnBoxes[1].contains(other.position()) && !this.onLastPage()) {
                    someHandPageTurning = true;
                    this.startVRPageTurn(PageChangeState.RIGHT_TO_LEFT, i);
                }
            } else if (!this.pageChangeState.isAnim && this.pageTurnBoxes[2].contains(other.position())) {
                boolean doingLToR = this.pageChangeState == PageChangeState.LEFT_TO_RIGHT;
                double distToLeft = other.position().distanceTo(this.pageTurnPositions[0]);
                double distToRight = other.position().distanceTo(this.pageTurnPositions[1]);
                if (doingLToR && distToRight < distToLeft) {
                    this.pageChangeState = PageChangeState.LEFT_TO_RIGHT_ANIM;
                    this.lastPage();
                } else if (!doingLToR && distToLeft < distToRight) {
                    this.pageChangeState = PageChangeState.RIGHT_TO_LEFT_ANIM;
                    this.nextPage();
                } else if (doingLToR) {
                    this.leftPageTurn = (float)(distToLeft / (distToLeft + distToRight));
                    someHandPageTurning = true;
                    this.setDirty();
                } else {
                    this.rightPageTurn = 1.0f - (float)(distToRight / (distToLeft + distToRight));
                    someHandPageTurning = true;
                    this.setDirty();
                }
            }
            if (someHandPageTurning || this.pageChangeState.isAnim || this.pageChangeState == PageChangeState.NONE) continue;
            this.resetTurnState();
        }
    }

    public void nextPage() {
        this.setPage(this.leftPageIndex + 2);
    }

    public void lastPage() {
        this.setPage(this.leftPageIndex - 2);
    }

    public void setPage(int newPageIndex) {
        this.setPage(newPageIndex, true);
    }

    public void setPage(int newPageIndex, boolean runCallback) {
        if (newPageIndex % 2 != 0) {
            --newPageIndex;
        }
        if (newPageIndex > this.maxLeftPageIndex) {
            newPageIndex = this.maxLeftPageIndex;
        } else if (newPageIndex < 0) {
            newPageIndex = 0;
        }
        this.leftPageIndex = newPageIndex;
        this.setDirty();
        if (runCallback && this.onSetPageCallback != null) {
            this.onSetPageCallback.accept(this.leftPageIndex);
        }
    }

    public int getLeftPageIndex() {
        return this.leftPageIndex;
    }

    public void setMaxLeftPageIndex(int max) {
        if (max % 2 != 0) {
            --max;
        }
        this.maxLeftPageIndex = Math.max(max, 0);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void setNoLongerDirty() {
        this.isDirty = false;
    }

    public boolean onFirstPage() {
        return this.leftPageIndex == 0;
    }

    public boolean onLastPage() {
        return this.leftPageIndex == this.maxLeftPageIndex;
    }

    public void startNonVRPageTurnAnim(Player pageTurner, boolean isNextPage) {
        this.pageTurner = pageTurner;
        this.pageChangeState = isNextPage ? PageChangeState.RIGHT_TO_LEFT_ANIM : PageChangeState.LEFT_TO_RIGHT_ANIM;
        this.pageTurnerHandIndex = -1;
        if (isNextPage) {
            this.nextPage();
        } else {
            this.lastPage();
        }
        this.setDirty();
    }

    public PageChangeState getPageChangeState() {
        return this.pageChangeState;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.leftPageIndex).writeFloat(this.leftPageTurn).writeFloat(this.rightPageTurn).writeEnum((Enum)this.pageChangeState);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buffer) {
        this.leftPageIndex = buffer.readInt();
        this.leftPageTurn = buffer.readFloat();
        this.rightPageTurn = buffer.readFloat();
        this.pageChangeState = (PageChangeState)buffer.readEnum(PageChangeState.class);
    }

    public void resetTurnState() {
        this.pageTurnerHandIndex = -1;
        this.leftPageTurn = 0.0f;
        this.rightPageTurn = 1.0f;
        this.pageChangeState = PageChangeState.NONE;
        this.pageTurner = null;
        this.setDirty();
    }

    protected void startVRPageTurn(PageChangeState state, int handIndex) {
        this.pageTurnerHandIndex = handIndex;
        this.pageChangeState = state;
        this.setDirty();
        if (this.startVRPageTurnCallback != null) {
            this.startVRPageTurnCallback.accept(this);
        }
    }

    public Vec3 getLeftRightVector(PosRot bookPosRot, boolean left) {
        Vector3f leftF = new Vector3f(0.0f, 0.0f, 1.0f);
        leftF.rotate((Quaternionfc)Axis.YN.rotationDegrees(left ? 270.0f : 90.0f));
        leftF.rotate((Quaternionfc)Axis.ZP.rotationDegrees(bookPosRot.getRoll()));
        leftF.rotate((Quaternionfc)Axis.XN.rotationDegrees(bookPosRot.getPitch()));
        leftF.rotate((Quaternionfc)Axis.YN.rotationDegrees(bookPosRot.getYaw()));
        return new Vec3((double)leftF.x(), (double)leftF.y(), (double)leftF.z());
    }

    public Vec3 getAwayVector(PosRot hand) {
        Vector3f awayFromBookF = new Vector3f(0.0f, 1.0f, 0.0f);
        awayFromBookF.rotate((Quaternionfc)Axis.ZP.rotationDegrees(hand.getRoll()));
        awayFromBookF.rotate((Quaternionfc)Axis.XN.rotationDegrees(hand.getPitch()));
        awayFromBookF.rotate((Quaternionfc)Axis.YN.rotationDegrees(hand.getYaw()));
        return new Vec3((double)awayFromBookF.x(), (double)awayFromBookF.y(), (double)awayFromBookF.z());
    }
}

