/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.immersive.handler.ContainerHandler;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ChestToOpenSet;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ChestLikeHandler
extends ContainerHandler<ListOfItemsStorage> {
    @Override
    public boolean isValidBlock(BlockPos pos, Level level) {
        return !Lootr.lootrImpl.isLootrContainer(pos, level) || !Lootr.lootrImpl.disableLootrContainerCompat();
    }

    @Override
    public ListOfItemsStorage makeInventoryContents(ServerPlayer player, BlockPos pos) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Container lootrInv = Lootr.lootrImpl.getContainer(player, pos);
        Container inv = lootrInv != null ? lootrInv : (Container)player.level().getBlockEntity(pos);
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            items.add(inv.getItem(i));
        }
        return new ListOfItemsStorage(items, inv.getContainerSize());
    }

    @Override
    public boolean isDirtyForClientSync(ServerPlayer player, BlockPos pos) {
        if (Lootr.lootrImpl.isLootrContainer(pos, player.level())) {
            return Lootr.lootrImpl.isOpen(pos, (Player)player) && player.tickCount % 2 == 0;
        }
        return super.isDirtyForClientSync(player, pos);
    }

    @Override
    public ListOfItemsStorage getEmptyNetworkStorage() {
        return new ListOfItemsStorage();
    }

    public boolean canPlaceItem(ItemStack item) {
        return true;
    }

    @Override
    public void swap(int slot, InteractionHand hand, BlockPos pos, ServerPlayer player, ItemSwapAmount amount) {
        Container container = (Container)player.level().getBlockEntity(pos);
        Container lootrInv = Lootr.lootrImpl.getContainer(player, pos);
        if (lootrInv != null) {
            container = lootrInv;
        }
        ItemStack containerItem = container.getItem(slot).copy();
        ItemStack playerItem = player.getItemInHand(hand);
        if (!this.canPlaceItem(playerItem)) {
            return;
        }
        if (playerItem.isEmpty() || containerItem.isEmpty() || !Util.stacksEqualBesidesCount(containerItem, playerItem)) {
            player.setItemInHand(hand, containerItem);
            container.setItem(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(containerItem, playerItem, false);
            player.setItemInHand(hand, result.mergedFrom);
            container.setItem(slot, result.mergedInto);
        }
        container.setChanged();
    }

    @Override
    public void onStopTracking(ServerPlayer player, BlockPos pos) {
        ChestToOpenSet.closeChest((Player)player, pos);
    }
}

