/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.common.compat.apotheosis.Apoth;
import com.hammy275.immersivemc.common.compat.apotheosis.ApothStats;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ItemWorldStorageHandler;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ETableStorage;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.hammy275.immersivemc.server.api_impl.ConstantItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import com.hammy275.immersivemc.server.storage.world.impl.ETableWorldStorage;
import com.hammy275.immersivemc.server.swap.Swap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;

public class ETableHandler
extends ItemWorldStorageHandler<ETableStorage> {
    @Override
    public ETableStorage makeInventoryContents(ServerPlayer player, BlockPos pos) {
        BlockEntity tileEnt;
        ETableWorldStorage worldStorage = (ETableWorldStorage)WorldStoragesImpl.getOrCreateS(pos, player.serverLevel());
        ETableStorage storage = new ETableStorage(Arrays.asList(worldStorage.getItemsRaw()));
        if (worldStorage.getItem(0) != null && !worldStorage.getItem(0).isEmpty() && (tileEnt = player.level().getBlockEntity(pos)) instanceof EnchantingTableBlockEntity) {
            if (Apoth.apothImpl.enchantModuleEnabled()) {
                ApothStats stats;
                ETableStorage.SlotData[] slots = Apoth.apothImpl.getEnchData((Player)player, pos, worldStorage.getItem(0));
                if (slots != null) {
                    storage.slots = slots;
                }
                if ((stats = Apoth.apothImpl.getStats(player.level(), pos, worldStorage.getItem(0).getItem().getEnchantmentValue())) != null) {
                    storage.apothStats = stats;
                }
            } else {
                EnchantmentMenu container = new EnchantmentMenu(-1, player.getInventory(), ContainerLevelAccess.create((Level)player.level(), (BlockPos)pos));
                container.setItem(1, 0, new ItemStack((ItemLike)Items.LAPIS_LAZULI, 64));
                container.setItem(0, 0, worldStorage.getItem(0));
                for (int i = 0; i <= 2; ++i) {
                    storage.slots[i] = new ETableStorage.SlotData(container.costs[i], List.of(Integer.valueOf(container.enchantClue[i])), List.of(Integer.valueOf(container.levelClue[i])));
                }
            }
        }
        return storage;
    }

    @Override
    public boolean isDirtyForClientSync(ServerPlayer player, BlockPos pos) {
        WorldStorage storage;
        if (Apoth.apothImpl.enchantModuleEnabled() && (storage = WorldStoragesImpl.getS(pos, player.serverLevel())) instanceof ETableWorldStorage) {
            ETableWorldStorage ews = (ETableWorldStorage)storage;
            ews.setDirtyFromApothStats(Apoth.apothImpl.getStats(player.level(), pos, 1));
        }
        return super.isDirtyForClientSync(player, pos);
    }

    @Override
    public ETableStorage getEmptyNetworkStorage() {
        return new ETableStorage();
    }

    @Override
    public void swap(int slot, InteractionHand hand, BlockPos pos, ServerPlayer player, ItemSwapAmount amount) {
        if (player == null) {
            return;
        }
        ETableWorldStorage enchStorage = (ETableWorldStorage)WorldStoragesImpl.getOrCreateS(pos, player.serverLevel());
        if (slot == 0) {
            ItemStack toEnchant = player.getItemInHand(hand);
            if (!(toEnchant.isEmpty() || toEnchant.isEnchantable() || Apoth.apothImpl.enchantModuleEnabled())) {
                return;
            }
            if (enchStorage.getItem(0).isEmpty()) {
                enchStorage.placeItem((Player)player, hand, slot, new ConstantItemSwapAmount(1));
            } else {
                SwapResult result = ImmersiveLogicHelpers.instance().swapItems(toEnchant, enchStorage.getItem(0), amount, (Player)player);
                result.giveToPlayer((Player)player, hand);
                enchStorage.setItem(0, result.immersiveStack(), (Player)player);
            }
        } else {
            boolean res = Swap.doEnchanting(slot, pos, player, hand);
            if (res) {
                VRRumble.rumbleIfVR((Player)player, hand.ordinal(), 0.15f);
            }
        }
        enchStorage.setDirty(player.serverLevel());
    }

    @Override
    public boolean isValidBlock(BlockPos pos, Level level) {
        return level.getBlockState(pos).getBlock() instanceof EnchantingTableBlock;
    }

    @Override
    public boolean enabledInConfig(Player player) {
        return ActiveConfig.getActiveConfigCommon((Player)player).useEnchantingTableImmersive && !Apoth.apothImpl.suppressVanillaEnchanting() || ActiveConfig.getActiveConfigCommon((Player)player).useApotheosisEnchantmentTableImmersive && Apoth.apothImpl.suppressVanillaEnchanting();
    }

    @Override
    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"enchanting_table");
    }

    @Override
    public WorldStorage getEmptyWorldStorage() {
        return new ETableWorldStorage();
    }

    @Override
    public Class<? extends WorldStorage> getWorldStorageClass() {
        return ETableWorldStorage.class;
    }
}

