/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ContainerHandler;
import com.hammy275.immersivemc.common.immersive.handler.HandlerUtil;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;

public class FurnaceHandler
extends ContainerHandler<ListOfItemsStorage> {
    @Override
    public ListOfItemsStorage makeInventoryContents(ServerPlayer player, BlockPos pos) {
        return HandlerUtil.makeInventoryContentsFromContainer(player, (Container)player.level().getBlockEntity(pos), 3);
    }

    @Override
    public ListOfItemsStorage getEmptyNetworkStorage() {
        return new ListOfItemsStorage();
    }

    @Override
    public void swap(int slot, InteractionHand hand, BlockPos pos, ServerPlayer player, ItemSwapAmount amount) {
        WorldlyContainer furnace = (WorldlyContainer)player.level().getBlockEntity(pos);
        ItemStack furnaceItem = furnace.getItem(slot).copy();
        ItemStack playerItem = player.getItemInHand(hand).copy();
        if (slot != 2) {
            if (slot != 1 || furnace.canPlaceItem(1, playerItem) || playerItem.isEmpty()) {
                SwapResult result = ImmersiveLogicHelpers.instance().swapItems(playerItem, furnaceItem, amount, (Player)player);
                result.giveToPlayer((Player)player, hand);
                furnace.setItem(slot, result.immersiveStack());
            }
        } else {
            SwapResult result = ImmersiveLogicHelpers.instance().swapItemsWithOutput(playerItem, furnaceItem, (Player)player);
            result.giveToPlayer((Player)player, hand);
            furnace.setItem(2, result.immersiveStack());
            this.awardXP(furnace, player);
        }
        furnace.setChanged();
    }

    @Override
    public boolean isValidBlock(BlockPos pos, Level level) {
        return level.getBlockEntity(pos) instanceof AbstractFurnaceBlockEntity;
    }

    @Override
    public boolean enabledInConfig(Player player) {
        return ActiveConfig.getActiveConfigCommon((Player)player).useFurnaceImmersive;
    }

    @Override
    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"furnace");
    }

    protected void awardXP(WorldlyContainer furnace, ServerPlayer player) {
        if (furnace instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity afbe = (AbstractFurnaceBlockEntity)furnace;
            afbe.awardUsedRecipesAndPopExperience(player);
        }
    }
}

