/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.WorldStorageHandler;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public abstract class ItemWorldStorageHandler<S extends NetworkStorage>
implements WorldStorageHandler<S> {
    @Override
    public boolean isDirtyForClientSync(ServerPlayer player, BlockPos pos) {
        WorldStorage worldStorage = WorldStoragesImpl.getS(pos, player.serverLevel());
        if (worldStorage instanceof ItemStorage) {
            ItemStorage iws = (ItemStorage)worldStorage;
            return iws.isDirtyForClientSync();
        }
        return false;
    }

    @Override
    public void onStopTracking(ServerPlayer player, BlockPos pos) {
        WorldStorage worldStorage = WorldStoragesImpl.getWithoutVerificationS(pos, player.serverLevel());
        if (worldStorage instanceof ItemStorage) {
            ItemStorage iws = (ItemStorage)worldStorage;
            if (Util.isValidBlocks(this, pos, player.level())) {
                if (ActiveConfig.getConfigForPlayer((Player)player).returnItemsWhenLeavingImmersives) {
                    iws.returnItems((Player)player);
                    this.updateStorageOutputAfterItemReturn(player, pos, iws);
                    iws.setDirty(player.serverLevel());
                }
            } else if (player.level().getBlockState(pos).isAir()) {
                for (int i = 0; i <= iws.maxInputIndex; ++i) {
                    Vec3 vecPos = Vec3.atCenterOf((Vec3i)pos);
                    ItemStack stack = iws.getItem(i);
                    if (stack == null || stack.isEmpty()) continue;
                    ItemEntity itemEnt = new ItemEntity(player.level(), vecPos.x, vecPos.y, vecPos.z, stack);
                    player.level().addFreshEntity((Entity)itemEnt);
                }
                WorldStoragesImpl.removeS(pos, player.serverLevel());
            }
        }
    }

    public void updateStorageOutputAfterItemReturn(ServerPlayer player, BlockPos pos, ItemStorage storage) {
    }
}

