/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.storage.dual.impl;

import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.handler.WorldStorageHandler;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class AnvilStorage
extends ItemStorage {
    public int xpLevels = 0;

    public AnvilStorage() {
        super(3, 1);
    }

    public WorldStorageHandler<AnvilStorage> getHandler() {
        return ImmersiveHandlers.anvilHandler;
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider provider, int lastVanillaDataVersion) {
        super.load(nbt, provider, lastVanillaDataVersion);
        this.xpLevels = nbt.getInt("xpLevels");
    }

    @Override
    public CompoundTag save(CompoundTag nbtIn, HolderLookup.Provider provider) {
        CompoundTag nbt = super.save(nbtIn, provider);
        nbt.putInt("xpLevels", this.xpLevels);
        return nbt;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.xpLevels);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buffer) {
        super.decode(buffer);
        this.xpLevels = buffer.readInt();
    }
}

