/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.storage.network.impl;

import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRUtil;
import com.hammy275.immersivemc.mixin.LecternBlockEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LecternData<T extends CommonBookData>
implements NetworkStorage {
    public ItemStack book = ItemStack.EMPTY;
    public T bookData;
    public transient BlockPos pos = BlockPos.ZERO;
    public transient Level level = null;

    public LecternData(T bookData) {
        this.bookData = bookData;
    }

    public void setBook(ItemStack book, @Nullable LecternBlockEntity lecternServerSide) {
        if (!ItemStack.matches((ItemStack)book, (ItemStack)this.book)) {
            this.book = book;
            ((CommonBookData)this.bookData).resetTurnState();
            ((CommonBookData)this.bookData).setMaxLeftPageIndex(this.findMaxLeftPageIndex());
            if (lecternServerSide != null) {
                ((CommonBookData)this.bookData).setPage(lecternServerSide.getPage());
                ((CommonBookData)this.bookData).onSetPageCallback = newPage -> ((LecternBlockEntityAccessor)lecternServerSide).immersiveMC$setPage((int)newPage);
            }
        }
    }

    public void tick(@Nullable Player player) {
        LecternBlockEntity lectern;
        int lecternPageNum;
        if (this.level == null || !ImmersiveHandlers.lecternHandler.isValidBlock(this.pos, this.level)) {
            return;
        }
        if (!this.level.isClientSide && (lecternPageNum = (lectern = (LecternBlockEntity)this.level.getBlockEntity(this.pos)).getPage()) != ((CommonBookData)this.bookData).getLeftPageIndex() && lecternPageNum != ((CommonBookData)this.bookData).getLeftPageIndex() + 1) {
            ((CommonBookData)this.bookData).setPage(lecternPageNum, false);
        }
        if (player != null) {
            ((CommonBookData)this.bookData).pageTurner = player;
        }
        if (((CommonBookData)this.bookData).pageTurner == null) {
            return;
        }
        if (!VRPluginVerify.playerInVR(((CommonBookData)this.bookData).pageTurner) && ((CommonBookData)this.bookData).getPageChangeState() != PageChangeState.NONE && !((CommonBookData)this.bookData).getPageChangeState().isAnim) {
            ((CommonBookData)this.bookData).startNonVRPageTurnAnim(((CommonBookData)this.bookData).pageTurner, ((CommonBookData)this.bookData).getPageChangeState() == PageChangeState.RIGHT_TO_LEFT);
        }
        PosRot lecternPosRot = this.getLecternPosRot(this.pos);
        if (VRPluginVerify.playerInVR(((CommonBookData)this.bookData).pageTurner)) {
            ((CommonBookData)this.bookData).tick(lecternPosRot, VRUtil.posRot(VRPlugin.API.getVRPlayer(((CommonBookData)this.bookData).pageTurner).getController0()), VRUtil.posRot(VRPlugin.API.getVRPlayer(((CommonBookData)this.bookData).pageTurner).getController1()));
        } else {
            ((CommonBookData)this.bookData).tick(lecternPosRot, new PosRot[0]);
        }
    }

    public PosRot getLecternPosRot(BlockPos pos) {
        Direction lecternDir = (Direction)this.level.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Vec3 lecternPos = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 1.0, 0.0).add(Vec3.atLowerCornerOf((Vec3i)lecternDir.getNormal()).scale(0.1));
        return new PosRot(lecternPos, Util.getLookAngle(-0.3926991f, (float)(-Math.toRadians(lecternDir.getOpposite().toYRot()))), 22.5f, lecternDir.getOpposite().toYRot(), 0.0f);
    }

    protected int findMaxLeftPageIndex() {
        if (this.book.isEmpty()) {
            return 0;
        }
        int size = 0;
        if (this.book.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            size = ((WrittenBookContent)this.book.get(DataComponents.WRITTEN_BOOK_CONTENT)).pages().size();
        } else if (this.book.has(DataComponents.WRITABLE_BOOK_CONTENT)) {
            size = ((WritableBookContent)this.book.get(DataComponents.WRITABLE_BOOK_CONTENT)).pages().size();
        }
        return Math.max(size - 1, 0);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.book);
        ((CommonBookData)this.bookData).encode(buffer);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buffer) {
        this.book = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        ((CommonBookData)this.bookData).decode(buffer);
    }
}

