/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ChestToOpenSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;

public class ChestShulkerOpenPacket {
    public BlockPos pos;
    public boolean isOpen;

    public ChestShulkerOpenPacket(BlockPos pos, boolean isOpenPacket) {
        this.pos = pos;
        this.isOpen = isOpenPacket;
    }

    public static void encode(ChestShulkerOpenPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(packet.pos).writeBoolean(packet.isOpen);
    }

    public static ChestShulkerOpenPacket decode(RegistryFriendlyByteBuf buffer) {
        return new ChestShulkerOpenPacket(buffer.readBlockPos(), buffer.readBoolean());
    }

    public static void handle(ChestShulkerOpenPacket message, ServerPlayer player) {
        if (player != null && NetworkUtil.safeToRun(message.pos, player)) {
            BlockEntity tileEnt = player.level().getBlockEntity(message.pos);
            boolean maybeMarkOpen = true;
            if (tileEnt instanceof ChestBlockEntity) {
                if (!ActiveConfig.FILE_SERVER.useChestImmersive) {
                    return;
                }
                ChestBlockEntity chest = (ChestBlockEntity)tileEnt;
                ChestBlockEntity other = Util.getOtherChest(chest);
                if (message.isOpen) {
                    chest.startOpen((Player)player);
                    ChestToOpenSet.openChest((Player)player, chest.getBlockPos());
                    if (other != null) {
                        other.startOpen((Player)player);
                        ChestToOpenSet.openChest((Player)player, other.getBlockPos());
                    }
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
                } else {
                    chest.stopOpen((Player)player);
                    ChestToOpenSet.closeChest((Player)player, chest.getBlockPos());
                    if (other != null) {
                        other.stopOpen((Player)player);
                        ChestToOpenSet.closeChest((Player)player, other.getBlockPos());
                    }
                }
            } else if (tileEnt instanceof EnderChestBlockEntity) {
                if (!ActiveConfig.FILE_SERVER.useChestImmersive) {
                    return;
                }
                EnderChestBlockEntity chest = (EnderChestBlockEntity)tileEnt;
                if (message.isOpen) {
                    chest.startOpen((Player)player);
                    ChestToOpenSet.openChest((Player)player, chest.getBlockPos());
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
                } else {
                    chest.stopOpen((Player)player);
                    ChestToOpenSet.closeChest((Player)player, chest.getBlockPos());
                }
                maybeMarkOpen = false;
            } else if (tileEnt instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)tileEnt;
                if (!ActiveConfig.FILE_SERVER.useShulkerImmersive) {
                    return;
                }
                if (message.isOpen) {
                    shulkerBox.startOpen((Player)player);
                } else {
                    shulkerBox.stopOpen((Player)player);
                }
            } else if (tileEnt instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)tileEnt;
                if (!ActiveConfig.FILE_SERVER.useBarrelImmersive) {
                    return;
                }
                if (message.isOpen) {
                    barrel.startOpen((Player)player);
                    ChestToOpenSet.openChest((Player)player, barrel.getBlockPos());
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
                } else {
                    barrel.stopOpen((Player)player);
                    ChestToOpenSet.closeChest((Player)player, barrel.getBlockPos());
                }
            } else if (!Lootr.lootrImpl.openLootrBarrel(message.pos, (Player)player, message.isOpen) && !Lootr.lootrImpl.openLootrShulkerBox(message.pos, (Player)player, message.isOpen)) {
                maybeMarkOpen = false;
            }
            if (maybeMarkOpen) {
                Lootr.lootrImpl.markOpener((Player)player, message.pos);
            }
        }
    }
}

