/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.NetworkClientHandlers;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ConfigSyncPacket {
    public final ActiveConfig config;
    @Nullable
    public final List<ResourceLocation> handlerIDs;

    public ConfigSyncPacket(ActiveConfig config) {
        this(config, null);
    }

    public ConfigSyncPacket(ActiveConfig config, @Nullable List<ResourceLocation> handlerIDs) {
        this.config = config;
        this.handlerIDs = handlerIDs;
    }

    public static void encode(ConfigSyncPacket packet, RegistryFriendlyByteBuf buffer) {
        packet.config.encode(buffer);
        buffer.writeInt(packet.handlerIDs == null ? 0 : packet.handlerIDs.size());
        if (packet.handlerIDs != null) {
            packet.handlerIDs.forEach(arg_0 -> ((RegistryFriendlyByteBuf)buffer).writeResourceLocation(arg_0));
        }
    }

    public static ConfigSyncPacket decode(RegistryFriendlyByteBuf buffer) {
        ActiveConfig incoming = ActiveConfig.decode(buffer);
        ArrayList<ResourceLocation> handlerIDs = null;
        int numIDs = buffer.readInt();
        if (numIDs > 0) {
            handlerIDs = new ArrayList<ResourceLocation>();
            for (int i = 0; i < numIDs; ++i) {
                handlerIDs.add(buffer.readResourceLocation());
            }
        }
        return new ConfigSyncPacket(incoming, handlerIDs);
    }

    public static void handle(ConfigSyncPacket message, ServerPlayer player) {
        if (player == null) {
            if (message.handlerIDs != null) {
                NetworkClientHandlers.checkHandlerMatch(message.handlerIDs);
            }
            ActiveConfig.FROM_SERVER = message.config;
            ActiveConfig.loadActive();
            ClientUtil.clearDisabledImmersives();
            Network.INSTANCE.sendToServer(new ConfigSyncPacket(ActiveConfig.FILE_CLIENT));
        } else {
            message.config.mergeWithServer(ActiveConfig.FILE_SERVER);
            ActiveConfig.registerPlayerConfig((Player)player, (ClientActiveConfig)message.config);
            TrackedImmersives.clearForPlayer(player);
        }
    }

    public static void syncConfigToPlayer(ServerPlayer player) {
        Network.INSTANCE.sendToPlayer(player, new ConfigSyncPacket(ImmersiveMCPlayerStorages.isPlayerDisabled((Player)player) ? ActiveConfig.DISABLED : ActiveConfig.FILE_SERVER));
    }
}

