/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FetchBackpackStoragePacket {
    public final List<ItemStack> backpackCraftingItems;

    public FetchBackpackStoragePacket() {
        this.backpackCraftingItems = null;
    }

    public FetchBackpackStoragePacket(List<ItemStack> items) {
        this.backpackCraftingItems = items;
    }

    public static void encode(FetchBackpackStoragePacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.backpackCraftingItems != null);
        if (packet.backpackCraftingItems != null) {
            buffer.writeInt(packet.backpackCraftingItems.size());
            packet.backpackCraftingItems.forEach(item -> ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, item));
        }
    }

    public static FetchBackpackStoragePacket decode(RegistryFriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            int numItems = buffer.readInt();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(numItems);
            for (int i = 0; i < numItems; ++i) {
                items.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
            }
            return new FetchBackpackStoragePacket(items);
        }
        return new FetchBackpackStoragePacket(null);
    }

    public static void handle(FetchBackpackStoragePacket message, ServerPlayer player) {
        if (player == null) {
            FetchBackpackStoragePacket.handleClient(message);
        } else {
            Network.INSTANCE.sendToPlayer(player, new FetchBackpackStoragePacket(ImmersiveMCPlayerStorages.getBackpackCraftingStorage((Player)player)));
        }
    }

    public static void handleClient(FetchBackpackStoragePacket message) {
        Immersives.immersiveBackpack.processFromNetwork(message.backpackCraftingItems);
    }
}

