/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.LecternData;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.storage.server.SharedNetworkStorages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PageTurnPacket {
    public final BlockPos pos;
    public final int forcedPageIndex;
    public final boolean clickedRight;

    public PageTurnPacket(BlockPos pos) {
        this(pos, -1);
    }

    public PageTurnPacket(BlockPos pos, int forcedPageIndex) {
        this(pos, forcedPageIndex, false);
    }

    public PageTurnPacket(BlockPos pos, boolean clickedRight) {
        this(pos, -1, clickedRight);
    }

    public PageTurnPacket(BlockPos pos, int forcedPageIndex, boolean clickedRight) {
        this.pos = pos;
        this.forcedPageIndex = forcedPageIndex;
        this.clickedRight = clickedRight;
    }

    public static void encode(PageTurnPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(packet.pos).writeInt(packet.forcedPageIndex).writeBoolean(packet.clickedRight);
    }

    public static PageTurnPacket decode(RegistryFriendlyByteBuf buffer) {
        return new PageTurnPacket(buffer.readBlockPos(), buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(PageTurnPacket message, ServerPlayer player) {
        LecternData<CommonBookData> storage;
        if (NetworkUtil.safeToRun(message.pos, player) && (storage = SharedNetworkStorages.instance().get(player.level(), message.pos, ImmersiveHandlers.lecternHandler)) != null && !storage.book.isEmpty() && ((CommonBookData)storage.bookData).pageTurner == null) {
            if (message.forcedPageIndex == -1) {
                if (!VRPluginVerify.playerInVR((Player)player) && (message.clickedRight ? !((CommonBookData)storage.bookData).onLastPage() : !((CommonBookData)storage.bookData).onFirstPage())) {
                    ((CommonBookData)storage.bookData).startNonVRPageTurnAnim((Player)player, message.clickedRight);
                } else if (VRPluginVerify.playerInVR((Player)player)) {
                    ((CommonBookData)storage.bookData).pageTurner = player;
                }
            } else {
                ((CommonBookData)storage.bookData).setPage(message.forcedPageIndex);
            }
        }
    }
}

