/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.data.AboutToThrowData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.phys.Vec3;

public class ThrowPacket {
    private final Vec3 velocity;
    private Vec3 dir;

    public ThrowPacket(Vec3 velocity, Vec3 dir) {
        this.velocity = velocity;
        this.dir = dir;
    }

    public static void encode(ThrowPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeDouble(packet.velocity.x).writeDouble(packet.velocity.y).writeDouble(packet.velocity.z).writeDouble(packet.dir.x).writeDouble(packet.dir.y).writeDouble(packet.dir.z);
    }

    public static ThrowPacket decode(RegistryFriendlyByteBuf buffer) {
        return new ThrowPacket(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    public static void handle(ThrowPacket packet, ServerPlayer player) {
        ItemStack itemInHand;
        packet.dir = packet.dir.normalize();
        if (player != null && ActiveConfig.FILE_SERVER.useThrowingImmersive && Util.isThrowableItem((itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem())) {
            if (itemInHand.getItem() instanceof FishingRodItem && player.fishing != null) {
                return;
            }
            AboutToThrowData.aboutToThrowMap.put(player.getUUID(), new AboutToThrowData.ThrowRecord(packet.velocity, packet.dir));
            if (itemInHand.getItem() instanceof TridentItem) {
                itemInHand.getItem().releaseUsing(itemInHand, player.level(), (LivingEntity)player, 71000);
            } else {
                itemInHand.getItem().use(player.level(), (Player)player, InteractionHand.MAIN_HAND);
            }
        }
    }
}

