/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.obb;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;

public class OBBClientUtil {
    public static void renderOBB(PoseStack stack, OBB obb, boolean forceRender, float red, float green, float blue, float alpha) {
        if ((Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes() || forceRender) && obb != null) {
            Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
            stack.pushPose();
            stack.translate(-renderInfo.getPosition().x + obb.getCenter().x, -renderInfo.getPosition().y + obb.getCenter().y, -renderInfo.getPosition().z + obb.getCenter().z);
            OBBClientUtil.rotateStackForOBB(stack, obb);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)buffer.getBuffer((RenderType)RenderType.LINES), (AABB)obb.getUnderlyingAABB().move(obb.getCenter().scale(-1.0)), (float)red, (float)green, (float)blue, (float)alpha);
            stack.popPose();
        }
    }

    public static void rotateStackForOBB(PoseStack stack, OBB obb) {
        stack.mulPose(obb.getRotation());
    }
}

