/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.tracker;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class BottleAndBucketTracker
extends AbstractTracker {
    private final Map<UUID, Integer> cooldown = new HashMap<UUID, Integer>();

    @Override
    protected void tick(Player player) {
        for (int c = 0; c <= 1; ++c) {
            boolean isWaterSource;
            BucketPickup bp;
            IVRPlayer currentVRData;
            InteractionHand hand = InteractionHand.values()[c];
            ItemStack stackInHand = player.getItemInHand(hand);
            if (!this.stackMatches(stackInHand) || !(Math.abs((currentVRData = VRPlugin.API.getVRPlayer(player)).getController(hand.ordinal()).getRoll()) < 90.0f)) continue;
            boolean holdingGlassBottle = stackInHand.is(Items.GLASS_BOTTLE);
            BlockPos pos = BlockPos.containing((Position)currentVRData.getController(hand.ordinal()).position());
            BlockState state = player.level().getBlockState(pos);
            Block block = state.getBlock();
            BucketPickup pickup = block instanceof BucketPickup ? (bp = (BucketPickup)block) : null;
            boolean bl = isWaterSource = state.is(Blocks.WATER) && (Integer)state.getValue((Property)BlockStateProperties.LEVEL) == 0;
            if ((!holdingGlassBottle || !isWaterSource) && pickup == null) continue;
            this.possiblyPlaceItemAndSetCooldown(player, hand, Util.doUse(player, hand, pos));
        }
    }

    @Override
    protected boolean shouldTick(Player player) {
        if (!VRPluginVerify.playerInVR(player)) {
            return false;
        }
        if (!ActiveConfig.getActiveConfigCommon((Player)player).useBucketAndBottleImmersive) {
            return false;
        }
        int newCooldown = this.cooldown.getOrDefault(player.getUUID(), 0) - 1;
        if (newCooldown > 0) {
            this.cooldown.put(player.getUUID(), newCooldown);
            return false;
        }
        this.cooldown.remove(player.getUUID());
        return true;
    }

    private boolean stackMatches(ItemStack stackInHand) {
        BucketItem bucketItem;
        Item item;
        return stackInHand.is(Items.GLASS_BOTTLE) || (item = stackInHand.getItem()) instanceof BucketItem && Platform.getFluid(bucketItem = (BucketItem)item).isSame(Fluids.EMPTY);
    }

    private void possiblyPlaceItemAndSetCooldown(Player player, InteractionHand hand, InteractionResultHolder<ItemStack> res) {
        if (res.getResult().consumesAction() && !((ItemStack)res.getObject()).isEmpty()) {
            this.cooldown.put(player.getUUID(), 5);
            player.setItemInHand(hand, (ItemStack)res.getObject());
        }
    }
}

