/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.util;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.common.obb.OBBRotList;
import com.hammy275.immersivemc.common.obb.RotType;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import net.blf02.vrapi.api.data.IVRData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class ShieldUtil {
    private static final double backAmount = 0.103515625;
    private static final double sideAmount = 0.111328125;
    private static final double downAmount = 0.037109375;

    public static OBB getShieldHitbox(Player player, IVRData hand, InteractionHand iHand) {
        Vec3 pos = ShieldUtil.getShieldPos(player, hand, iHand);
        return OBBFactory.instance().create(AABB.ofSize((Vec3)pos, (double)0.421875, (double)0.7734375, (double)0.1875), (Quaternionfc)ShieldUtil.makeRotList(player, hand, iHand).asQuaternion());
    }

    public static Vec3 getShieldPos(Player player, IVRData hand, InteractionHand iHand) {
        Vec3 translate = new Vec3(0.111328125 * (double)ShieldUtil.getNegMult(player, iHand), -0.037109375, -0.103515625).zRot((float)(-Math.toRadians(hand.getRoll()))).xRot((float)Math.toRadians(hand.getPitch())).yRot((float)(-Math.toRadians(hand.getYaw())));
        return hand.position().add(translate);
    }

    private static OBBRotList makeRotList(Player player, IVRData hand, InteractionHand iHand) {
        return OBBRotList.create().addRot(Math.toRadians(hand.getYaw()), RotType.YAW).addRot(Math.toRadians(hand.getPitch()), RotType.PITCH).addRot(Math.toRadians(hand.getRoll()), RotType.ROLL).addRot(1.5707963267948966 * (double)ShieldUtil.getNegMult(player, iHand), RotType.YAW);
    }

    private static float getNegMult(Player player, InteractionHand iHand) {
        float negMult = VRPlugin.API.isLeftHanded(player) ? -1.0f : 1.0f;
        return iHand == InteractionHand.MAIN_HAND ? negMult * -1.0f : negMult * 1.0f;
    }
}

