/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.util;

import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.MultiblockImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.immersive.ImmersiveChecker;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static UseInfo activeUseInfo = null;

    public static boolean blockIsActiveImmersive(Player player, BlockPos pos) {
        Level level = player.level();
        if (level.isClientSide) {
            for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> singleton : Immersives.IMMERSIVES) {
                ImmersiveHandler<? extends NetworkStorage> immersiveHandler = singleton.getHandler();
                if (immersiveHandler instanceof MultiblockImmersiveHandler) {
                    MultiblockImmersiveHandler handler = (MultiblockImmersiveHandler)immersiveHandler;
                    for (ImmersiveInfo immersiveInfo : singleton.getTrackedObjects()) {
                        Set<BlockPos> handledBlocks = handler.getHandledBlocks(pos, level);
                        if (handledBlocks == null || !handledBlocks.contains(immersiveInfo.getBlockPosition())) continue;
                        return true;
                    }
                    continue;
                }
                for (ImmersiveInfo immersiveInfo : singleton.getTrackedObjects()) {
                    if (!immersiveInfo.getBlockPosition().equals((Object)pos)) continue;
                    return true;
                }
            }
            return false;
        }
        return TrackedImmersives.TRACKED_IMMERSIVES.stream().anyMatch(data -> data.playerUUID.equals(player.getUUID()) && data.getPos().contains(pos));
    }

    public static InteractionHand otherHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractionResultHolder<ItemStack> doUse(Player player, InteractionHand hand, BlockPos pos) {
        InteractionResultHolder result;
        try {
            activeUseInfo = new UseInfo(player, hand, pos);
            result = player.getItemInHand(hand).use(player.level(), player, hand);
        }
        finally {
            activeUseInfo = null;
        }
        return result;
    }

    public static Vec3 getLookAngle(float pitch, float yaw) {
        float yawCos = Mth.cos((float)pitch);
        return new Vec3((double)(Mth.sin((float)yaw) * yawCos), (double)(-Mth.sin((float)pitch)), (double)(Mth.cos((float)yaw) * yawCos));
    }

    public static boolean isValidBlocks(ImmersiveHandler<?> handler, BlockPos pos, Level level) {
        return Util.getValidBlocks(handler, pos, level).contains(pos);
    }

    public static boolean isValidBlocks(ImmersiveHandler<?> handler, Set<BlockPos> pos, Level level) {
        return Util.getValidBlocks(handler, pos.iterator().next(), level).equals(pos);
    }

    public static Set<BlockPos> getValidBlocks(ImmersiveHandler<?> handler, BlockPos pos, Level level) {
        boolean valid = handler.isValidBlock(pos, level);
        if (valid) {
            if (handler instanceof MultiblockImmersiveHandler) {
                MultiblockImmersiveHandler mih = (MultiblockImmersiveHandler)handler;
                Set<BlockPos> positions = mih.getHandledBlocks(pos, level);
                if (positions != null && positions.stream().allMatch(p -> handler.isValidBlock((BlockPos)p, level))) {
                    return positions;
                }
                return Set.of();
            }
            return Set.of(pos);
        }
        return Set.of();
    }

    public static Vec3 average(Set<BlockPos> positions) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (BlockPos pos : positions) {
            x += (double)pos.getX();
            y += (double)pos.getY();
            z += (double)pos.getZ();
        }
        return new Vec3(x / (double)positions.size(), y / (double)positions.size(), z / (double)positions.size());
    }

    public static boolean isThrowableItem(Item item) {
        return item == Items.EXPERIENCE_BOTTLE || item == Items.EGG || item == Items.ENDER_PEARL || item == Items.SPLASH_POTION || item == Items.LINGERING_POTION || item == Items.SNOWBALL || item instanceof TridentItem || item instanceof FishingRodItem;
    }

    public static Direction horizontalDirectionFromLook(Vec3 look) {
        double maxLook = Math.max(Math.abs(look.x), Math.abs(look.z));
        if (maxLook == Math.abs(look.x)) {
            return look.x < 0.0 ? Direction.WEST : Direction.EAST;
        }
        return look.z < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public static boolean isHittingImmersive(BlockHitResult result, Level level) {
        BlockPos pos = result.getBlockPos();
        for (ImmersiveChecker checker : ImmersiveCheckers.CHECKERS) {
            if (!checker.apply(pos, level)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemInInventoryWithStackSpace(Player player, ItemStack stack) {
        for (ItemStack invItem : player.getInventory().items) {
            if (!Util.stacksEqualBesidesCount(invItem, stack) || invItem.getCount() >= invItem.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    public static boolean canPickUpItem(ItemEntity item, Player player) {
        return (!item.hasPickUpDelay() || player.getAbilities().instabuild) && Math.abs(item.getDeltaMovement().x) <= 0.01 && Math.abs(item.getDeltaMovement().z) <= 0.01;
    }

    public static Optional<Integer> rayTraceClosest(Pair<Vec3, Vec3> rayStartAndEnd, BoundingBox ... targets) {
        return Util.rayTraceClosest((Vec3)rayStartAndEnd.getFirst(), (Vec3)rayStartAndEnd.getSecond(), targets);
    }

    public static Optional<Integer> rayTraceClosest(Vec3 rayStart, Vec3 rayEnd, BoundingBox ... targets) {
        return Util.rayTraceClosest(rayStart, rayEnd, Arrays.stream(targets).toList());
    }

    public static Optional<Integer> rayTraceClosest(Vec3 rayStart, Vec3 rayEnd, Collection<? extends HitboxInfo> targets) {
        return Util.rayTraceClosest(rayStart, rayEnd, targets.stream().map(info -> info != null ? info.getHitbox() : null).toList());
    }

    public static Optional<Integer> rayTraceClosest(Vec3 rayStart, Vec3 rayEnd, Iterable<BoundingBox> targets) {
        double dist = Double.MAX_VALUE;
        Integer winner = null;
        int i = 0;
        for (BoundingBox target : targets) {
            if (target != null) {
                double distTemp;
                if (BoundingBox.contains(target, rayStart)) {
                    return Optional.of(i);
                }
                Optional<Vec3> closestHitOpt = target.isAABB() ? target.asAABB().clip(rayStart, rayEnd) : target.asOBB().rayHit(rayStart, rayEnd);
                double d = distTemp = closestHitOpt.isPresent() ? closestHitOpt.get().distanceToSqr(rayStart) : -1.0;
                if (closestHitOpt.isPresent() && distTemp < dist) {
                    winner = i;
                    dist = distTemp;
                }
            }
            ++i;
        }
        return Optional.ofNullable(winner);
    }

    public static Optional<Integer> getFirstIntersect(Vec3 pos, BoundingBox ... targets) {
        return Util.getFirstIntersect(pos, Arrays.stream(targets).toList());
    }

    public static Optional<Integer> getFirstIntersect(Vec3 pos, Collection<? extends HitboxInfo> targets) {
        return Util.getFirstIntersect(pos, targets.stream().map(info -> info != null ? info.getHitbox() : null).toList());
    }

    public static Optional<Integer> getFirstIntersect(Vec3 pos, Iterable<BoundingBox> targets) {
        int i = 0;
        for (BoundingBox target : targets) {
            if (target != null && BoundingBox.contains(target, pos)) {
                return Optional.of(i);
            }
            ++i;
        }
        return Optional.empty();
    }

    public static Optional<Integer> getClosestIntersect(Vec3 pos, List<BoundingBox> targets) {
        int res = -1;
        double distanceToBeat = Double.MAX_VALUE;
        for (int i = 0; i < targets.size(); ++i) {
            double newDist;
            if (targets.get(i) == null || !BoundingBox.contains(targets.get(i), pos) || !((newDist = pos.distanceToSqr(BoundingBox.getCenter(targets.get(i)))) < distanceToBeat)) continue;
            distanceToBeat = newDist;
            res = i;
        }
        return res == -1 ? Optional.empty() : Optional.of(res);
    }

    public static ChestBlockEntity getOtherChest(ChestBlockEntity chest) {
        return Util.getOtherChest(chest, true);
    }

    protected static ChestBlockEntity getOtherChest(ChestBlockEntity chest, boolean checkOther) {
        if (chest == null) {
            return null;
        }
        Direction otherDir = ChestBlock.getConnectedDirection((BlockState)chest.getBlockState());
        BlockPos otherPos = chest.getBlockPos().relative(otherDir);
        if (chest.getLevel() != null && chest.getLevel().getBlockEntity(otherPos) instanceof ChestBlockEntity) {
            ChestBlockEntity other = (ChestBlockEntity)chest.getLevel().getBlockEntity(otherPos);
            if (checkOther && other != null) {
                return Util.getOtherChest(other, false) == chest ? other : null;
            }
            return other;
        }
        return null;
    }

    public static boolean stacksEqualBesidesCount(ItemStack a, ItemStack b) {
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        int oldCountA = a.getCount();
        int oldCountB = b.getCount();
        a.setCount(1);
        b.setCount(1);
        boolean res = ItemStack.matches((ItemStack)a, (ItemStack)b);
        a.setCount(oldCountA);
        b.setCount(oldCountB);
        return res;
    }

    public static ItemStackMergeResult mergeStacks(ItemStack mergeIntoIn, ItemStack mergeFromIn, boolean useCopy) {
        return Util.mergeStacks(mergeIntoIn, mergeFromIn, useCopy, -1);
    }

    public static ItemStackMergeResult mergeStacks(ItemStack mergeIntoIn, ItemStack mergeFromIn, boolean useCopy, int forcedMaxMergeIntoSize) {
        int mergeIntoMaxStackSize;
        int n = mergeIntoMaxStackSize = forcedMaxMergeIntoSize == -1 ? mergeIntoIn.getMaxStackSize() : forcedMaxMergeIntoSize;
        if (!Util.stacksEqualBesidesCount(mergeIntoIn, mergeFromIn) || mergeIntoMaxStackSize <= 1) {
            return new ItemStackMergeResult(mergeIntoIn, mergeFromIn);
        }
        ItemStack into = useCopy ? mergeIntoIn.copy() : mergeIntoIn;
        ItemStack from = useCopy ? mergeFromIn.copy() : mergeFromIn;
        int totalCount = into.getCount() + from.getCount();
        int fromAmount = 0;
        if (totalCount > mergeIntoMaxStackSize) {
            fromAmount = totalCount - mergeIntoMaxStackSize;
            totalCount = mergeIntoMaxStackSize;
        }
        into.setCount(totalCount);
        from.setCount(fromAmount);
        return new ItemStackMergeResult(into, fromAmount == 0 ? ItemStack.EMPTY : from);
    }

    public static void setRepeater(Level level, BlockPos pos, int newDelay) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof RepeaterBlock) {
            state = (BlockState)state.setValue((Property)RepeaterBlock.DELAY, (Comparable)Integer.valueOf(newDelay));
            level.setBlock(pos, state, 3);
        }
    }

    public static void useLever(Player player, BlockPos pos) {
        if (ImmersiveCheckers.isLever(pos, player.level())) {
            BlockState lever = player.level().getBlockState(pos);
            lever.useWithoutItem(player.level(), player, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.NORTH, pos, true));
        }
    }

    public static void useTrapdoor(Player player, Level level, BlockPos pos) {
        if (ImmersiveHandlers.trapdoorHandler.isValidBlock(pos, level)) {
            BlockState trapdoor = level.getBlockState(pos);
            trapdoor.useWithoutItem(level, player, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.NORTH, pos, true));
        }
    }

    public static void useDoor(Player player, Level level, BlockPos pos) {
        if (ImmersiveHandlers.doorHandler.isValidBlock(pos, level)) {
            BlockState door = level.getBlockState(pos);
            door.useWithoutItem(level, player, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.NORTH, pos, true));
        }
    }

    public static Vec3 getPlayerVelocity(Vec3 lastTickPos, Vec3 currentTickPos) {
        return new Vec3(currentTickPos.x - lastTickPos.x, currentTickPos.y - lastTickPos.y, currentTickPos.z - lastTickPos.z);
    }

    public static double moveTowardsZero(double num, double subtract) {
        if ((subtract = Math.abs(subtract)) >= Math.abs(num)) {
            return 0.0;
        }
        if (num < 0.0) {
            return num + subtract;
        }
        return num - subtract;
    }

    public static void giveStackHandFirst(Player player, InteractionHand hand, ItemStack stack) {
        if (player.getItemInHand(hand).isEmpty()) {
            player.setItemInHand(hand, stack);
        } else {
            Util.placeLeftovers(player, stack);
        }
    }

    public static void placeLeftovers(Player player, ItemStack leftovers) {
        Util.placeLeftovers(player, leftovers, player.position());
    }

    public static void placeLeftovers(Player player, ItemStack leftovers, Vec3 pos) {
        if (!leftovers.isEmpty()) {
            ItemEntity item = new ItemEntity(player.level(), pos.x, pos.y, pos.z, leftovers);
            player.level().addFreshEntity((Entity)item);
        }
    }

    public static void putResourceLocation(CompoundTag nbt, String key, ResourceLocation loc) {
        CompoundTag locTag = new CompoundTag();
        locTag.putString("namespace", loc.getNamespace());
        locTag.putString("path", loc.getPath());
        nbt.put(key, (Tag)locTag);
    }

    public static ResourceLocation getResourceLocation(CompoundTag nbt, String key) {
        CompoundTag subTag = nbt.getCompound(key);
        return ResourceLocation.fromNamespaceAndPath((String)subTag.getString("namespace"), (String)subTag.getString("path"));
    }

    public static List<BlockPos> allPositionsWithAABB(AABB box) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int minX = (int)Math.floor(box.minX);
        int minY = (int)Math.floor(box.minY);
        int minZ = (int)Math.floor(box.minZ);
        int maxX = (int)Math.floor(box.maxX);
        int maxY = (int)Math.floor(box.maxY);
        int maxZ = (int)Math.floor(box.maxZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }

    public static Vec3[] get3x3HorizontalGrid(BlockPos blockPos, double spacing, Direction blockForward, boolean use3DCompat) {
        Vec3 pos = Vec3.upFromBottomCenterOf((Vec3i)blockPos, (double)1.0);
        if (use3DCompat) {
            pos = pos.add(0.0, 0.0625, 0.0);
        }
        Direction left = blockForward.getCounterClockWise();
        Vec3 leftOffset = new Vec3((double)left.getNormal().getX() * -spacing, 0.0, (double)left.getNormal().getZ() * -spacing);
        Vec3 rightOffset = new Vec3((double)left.getNormal().getX() * spacing, 0.0, (double)left.getNormal().getZ() * spacing);
        Vec3 topOffset = new Vec3((double)blockForward.getNormal().getX() * -spacing, 0.0, (double)blockForward.getNormal().getZ() * -spacing);
        Vec3 botOffset = new Vec3((double)blockForward.getNormal().getX() * spacing, 0.0, (double)blockForward.getNormal().getZ() * spacing);
        return new Vec3[]{pos.add(leftOffset).add(topOffset), pos.add(topOffset), pos.add(rightOffset).add(topOffset), pos.add(leftOffset), pos, pos.add(rightOffset), pos.add(leftOffset).add(botOffset), pos.add(botOffset), pos.add(rightOffset).add(botOffset)};
    }

    public static Direction getForwardFromPlayerUpAndDown(Player player, BlockPos pos) {
        return Util.getForwardFromPlayerUpAndDownFilterBlockFacing(player, pos, false);
    }

    public static Direction getForwardFromPlayerUpAndDownFilterBlockFacing(Player player, BlockPos pos, boolean filterOnBlockFacing) {
        Direction.Axis filter = filterOnBlockFacing ? ((Direction)player.level().getBlockState(pos).getValue((Property)DirectionalBlock.FACING)).getAxis() : null;
        Vec3 playerPos = player.position();
        if (playerPos.y >= (double)pos.getY() + 0.625 && filter != Direction.Axis.Y) {
            return Direction.UP;
        }
        if (playerPos.y <= (double)pos.getY() - 0.625 && filter != Direction.Axis.Y) {
            return Direction.DOWN;
        }
        Direction forward = ImmersiveLogicHelpers.instance().getHorizontalBlockForward(player, pos);
        if (forward.getAxis() != filter) {
            return forward;
        }
        Direction blockFacing = (Direction)player.level().getBlockState(pos).getValue((Property)DirectionalBlock.FACING);
        Vec3 blockCenter = Vec3.atCenterOf((Vec3i)pos);
        Direction blockLeftDir = blockFacing.getCounterClockWise();
        Vec3 blockLeftVec = new Vec3((double)blockLeftDir.getNormal().getX(), (double)blockLeftDir.getNormal().getY(), (double)blockLeftDir.getNormal().getZ());
        Vec3 counterClockwisePos = blockCenter.add(blockLeftVec.scale(0.5));
        Vec3 clockwisePos = blockCenter.add(blockLeftVec.scale(-0.5));
        Vec3 upPos = blockCenter.add(0.0, 0.5, 0.0);
        Vec3 downPos = blockCenter.add(0.0, -0.5, 0.0);
        double counterClockwiseDist = counterClockwisePos.distanceToSqr(playerPos);
        double clockwiseDist = clockwisePos.distanceToSqr(playerPos);
        double upDist = upPos.distanceToSqr(playerPos);
        double downDist = downPos.distanceToSqr(playerPos);
        double min = Math.min(counterClockwiseDist, clockwiseDist);
        min = Math.min(min, upDist);
        if ((min = Math.min(min, downDist)) == counterClockwiseDist) {
            return forward.getCounterClockWise();
        }
        if (min == clockwiseDist) {
            return forward.getClockWise();
        }
        if (min == upDist) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }

    public record UseInfo(Player player, InteractionHand hand, BlockPos pos) {
        public Vec3 getVec3Pos() {
            return Vec3.atCenterOf((Vec3i)this.pos);
        }
    }

    public static class ItemStackMergeResult {
        public final ItemStack mergedInto;
        public final ItemStack mergedFrom;

        public ItemStackMergeResult(ItemStack mergedInto, ItemStack mergedFrom) {
            this.mergedInto = mergedInto;
            this.mergedFrom = mergedFrom;
        }

        public String toString() {
            return "Merged Into: " + String.valueOf(this.mergedInto) + "\nMerged From: " + String.valueOf(this.mergedFrom);
        }
    }
}

