/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.vr.mixin_proxy;

import com.hammy275.immersivemc.client.ClientMixinProxy;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShieldProxy {
    public static ItemStack shieldToDamage = ItemStack.EMPTY;
    public static InteractionHand handWithShield = null;
    public static boolean useIsBlockingMixin = false;

    @Nullable
    public static ItemStack getABlockingShield(LivingEntity living) {
        Player player;
        if (living instanceof Player && ShieldProxy.isVRPlayerToManageBySide(player = (Player)living)) {
            for (InteractionHand iHand : InteractionHand.values()) {
                if (player.getItemInHand(iHand).getUseAnimation() != UseAnim.BLOCK) continue;
                return player.getItemInHand(iHand);
            }
        }
        return null;
    }

    public static boolean isDamageSourceBlocked(LivingEntity living, DamageSource damageSource) {
        Player player;
        if (living instanceof Player && ShieldProxy.isVRPlayerToManageBySide(player = (Player)living)) {
            IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
            for (InteractionHand iHand : InteractionHand.values()) {
                Vec3 attackerVec;
                if (player.getItemInHand(iHand).getUseAnimation() != UseAnim.BLOCK || player.getCooldowns().isOnCooldown(player.getItemInHand(iHand).getItem())) continue;
                float negMult = VRPlugin.API.isLeftHanded(player) ? -1.0f : 1.0f;
                negMult = iHand == InteractionHand.MAIN_HAND ? negMult * -1.0f : negMult * 1.0f;
                IVRData hand = vrPlayer.getController(iHand.ordinal());
                float toRot = (float)(1.5707963267948966 * (double)negMult);
                Vec3 handVec = hand.getLookAngle().yRot(toRot).normalize();
                double angle = Math.acos(handVec.dot(attackerVec = damageSource.getSourcePosition().vectorTo(player.position()).multiply(1.0, 0.0, 1.0).normalize()));
                if (!(angle <= Math.PI) || !(angle >= 2.0943951023931953)) continue;
                shieldToDamage = player.getItemInHand(iHand);
                handWithShield = iHand;
                return true;
            }
        }
        return false;
    }

    private static boolean isVRPlayerToManageBySide(Player player) {
        return VRPluginVerify.hasAPI && (!player.level().isClientSide || ClientMixinProxy.playerIsLocalPlayer(player)) && VRPlugin.API.playerInVR(player) && player.getUseItem().isEmpty() && ActiveConfig.getActiveConfigCommon((Player)player).useShieldImmersive;
    }
}

