/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.vr.mixin_proxy;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.server.data.AboutToThrowData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class ThrowRedirect {
    private static final double minThrowingVelocity = 0.01;
    private static final double mediumThrowingVelocity = 0.175;
    private static final double maxThrowingVelocity = 0.25;

    public static void shootFromRotation(Projectile projectile, Entity shooter, float xAngle, float yAngle, float unknown, float velocity, float inaccuracy) {
        ThrowRedirect.shootFromRotation(projectile, shooter, xAngle, yAngle, unknown, velocity, inaccuracy, true);
    }

    public static void shootFromRotation(Projectile projectile, Entity shooter, float xAngle, float yAngle, float unknown, float velocity, float inaccuracy, boolean doDefaultShotOtherwise) {
        Player player;
        if (shooter instanceof Player && VRPlugin.API.playerInVR(player = (Player)shooter) && AboutToThrowData.aboutToThrowMap.containsKey(player.getUUID())) {
            AboutToThrowData.ThrowRecord data = AboutToThrowData.aboutToThrowMap.remove(player.getUUID());
            projectile.shoot(data.dir().x, data.dir().y, data.dir().z, velocity * (float)ThrowRedirect.getVelocityMod(data), 0.0f);
            Vec3 shooterVelocity = shooter.getDeltaMovement();
            projectile.setDeltaMovement(projectile.getDeltaMovement().add(shooterVelocity.x, shooter.onGround() ? 0.0 : shooterVelocity.y, shooterVelocity.z));
            return;
        }
        if (doDefaultShotOtherwise) {
            projectile.shootFromRotation(shooter, xAngle, yAngle, unknown, velocity, inaccuracy);
        }
    }

    public static void deleteRecord(Player player) {
        if (VRPlugin.API.playerInVR(player)) {
            AboutToThrowData.aboutToThrowMap.remove(player.getUUID());
        }
    }

    public static double getVelocityMod(AboutToThrowData.ThrowRecord data) {
        double controllerVelocity = data.velocity().length();
        double projVelocityMod = controllerVelocity > 0.175 ? Math.sin(1.5707963267948966) : Math.sin(controllerVelocity * Math.PI / 2.0 / 0.175);
        double extraMod = 0.0;
        if (ActiveConfig.FILE_SERVER.allowThrowingBeyondVanillaMaxRange) {
            extraMod = (controllerVelocity - 0.175) / 4.0;
            extraMod = Math.min(extraMod, 0.05);
        }
        return projVelocityMod + extraMod;
    }
}

