/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.neoforge;

import com.hammy275.immersivemc.mixin.BucketItemAccessor;
import com.hammy275.immersivemc.neoforge.BufferPacket;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlatformImpl {
    public static boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    public static boolean isForgeLike() {
        return true;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static void registerServerPostTickListener(Consumer<MinecraftServer> listener) {
        NeoForge.EVENT_BUS.addListener(event -> listener.accept(event.getServer()));
    }

    public static void registerServerPlayerPostTickListener(Consumer<ServerPlayer> listener) {
        NeoForge.EVENT_BUS.addListener(event -> event.getServer().getPlayerList().getPlayers().forEach(listener));
    }

    public static void registerServerPlayerJoinListener(Consumer<ServerPlayer> listener) {
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerServerPlayerLeaveListener(Consumer<ServerPlayer> listener) {
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerCommands(Consumer<CommandDispatcher<CommandSourceStack>> listener) {
        NeoForge.EVENT_BUS.addListener(event -> listener.accept(event.getDispatcher()));
    }

    public static void sendToServer(RegistryFriendlyByteBuf message) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BufferPacket(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, RegistryFriendlyByteBuf message) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BufferPacket(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static Fluid getFluid(BucketItem bucket) {
        return ((BucketItemAccessor)bucket).immersiveMC$getFluid();
    }
}

