/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ChestToOpenSet {
    private static final Map<PosLevel, Set<Player>> chestImmersiveOpenSet = new HashMap<PosLevel, Set<Player>>();

    public static void openChest(Player player, BlockPos pos) {
        Set<Player> set = ChestToOpenSet.getOpenSet(player.level(), pos, true);
        set.add(player);
    }

    public static void closeChest(Player player, BlockPos pos) {
        Set<Player> set = ChestToOpenSet.getOpenSet(player.level(), pos, false);
        if (set != null) {
            set.remove(player);
            if (set.isEmpty()) {
                chestImmersiveOpenSet.remove(new PosLevel(pos, player.level()));
            }
        }
    }

    public static int getOpenCount(BlockPos pos, Level level) {
        Set<Player> set = ChestToOpenSet.getOpenSet(level, pos, false);
        return set != null ? set.size() : 0;
    }

    public static void clear() {
        chestImmersiveOpenSet.clear();
    }

    public static void clearForPlayer(Player player) {
        ArrayList toRemove = new ArrayList();
        chestImmersiveOpenSet.forEach((posLevel, set) -> {
            set.remove(player);
            if (set.isEmpty()) {
                toRemove.add(posLevel);
            }
        });
        toRemove.forEach(chestImmersiveOpenSet.keySet()::remove);
    }

    public static Set<Player> getOpenSet(Level level, BlockPos pos, boolean createIfNotPresent) {
        Set<Player> set = chestImmersiveOpenSet.get(new PosLevel(pos, level));
        if (createIfNotPresent && set == null) {
            set = new HashSet<Player>();
            chestImmersiveOpenSet.put(new PosLevel(pos, level), set);
        }
        return set;
    }

    private record PosLevel(BlockPos pos, Level level) {
        public boolean matches(BlockPos otherPos, Level otherLevel) {
            return this.pos.equals((Object)otherPos) && this.level == otherLevel;
        }
    }
}

