/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.command;

import com.hammy275.immersivemc.common.network.packet.ConfigSyncPacket;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ImmersiveMCCommand {
    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"immersivemc").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"enable").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> ImmersiveMCCommand.enableDisable((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), true))))).then(Commands.literal((String)"disable").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> ImmersiveMCCommand.enableDisable((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), false)))));
    }

    private static int enableDisable(CommandSourceStack source, ServerPlayer player, boolean nowEnabled) {
        boolean currentlyEnabled;
        boolean bl = currentlyEnabled = !ImmersiveMCPlayerStorages.isPlayerDisabled((Player)player);
        if (currentlyEnabled == nowEnabled) {
            source.sendFailure((Component)Component.translatableWithFallback((String)("commands.immersivemc.enable_disable.already_" + nowEnabled), (String)"This player already has ImmersiveMC %s!".formatted(nowEnabled ? "enabled" : "disabled")));
            return 0;
        }
        if (nowEnabled) {
            ImmersiveMCPlayerStorages.setPlayerEnabled((Player)player);
        } else {
            ImmersiveMCPlayerStorages.setPlayerDisabled((Player)player);
        }
        ConfigSyncPacket.syncConfigToPlayer(player);
        source.sendSuccess(() -> Component.translatableWithFallback((String)("commands.immersivemc.enable_disable." + nowEnabled), (String)"ImmersiveMC now %s for the provided player!".formatted(nowEnabled ? "enabled" : "disabled")), true);
        return 1;
    }
}

