/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.storage.world;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.handler.WorldStorageHandler;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.AnvilStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.SmithingTableStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ServerUtil;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class ImmersiveMCLevelStorage
extends SavedData {
    private static final int LEVEL_STORAGE_VERSION = 2;
    private static SavedData.Factory<ImmersiveMCLevelStorage> factory = new SavedData.Factory(ImmersiveMCLevelStorage::create, ImmersiveMCLevelStorage::load, null);
    private static final String DATA_KEY = "immersivemc_data";
    protected Map<BlockPos, WorldStorage> storageMap = new HashMap<BlockPos, WorldStorage>();

    private static ImmersiveMCLevelStorage create() {
        return new ImmersiveMCLevelStorage();
    }

    public static ImmersiveMCLevelStorage getLevelStorage(ServerLevel level) {
        return (ImmersiveMCLevelStorage)level.getDataStorage().computeIfAbsent(factory, DATA_KEY);
    }

    @Nullable
    public WorldStorage remove(BlockPos pos) {
        return this.storageMap.remove(pos);
    }

    @Nullable
    public WorldStorage get(BlockPos pos, Level level) {
        WorldStorage storage = this.storageMap.get(pos);
        for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
            WorldStorageHandler handler;
            if (!(handlerMaybeWS instanceof WorldStorageHandler) || !(handler = (WorldStorageHandler)handlerMaybeWS).getWorldStorageClass().isInstance(storage) || !Util.isValidBlocks(handler, pos, level)) continue;
            return storage;
        }
        return null;
    }

    @Nullable
    public WorldStorage getWithoutVerification(BlockPos pos, Level level) {
        return this.storageMap.get(pos);
    }

    @Nullable
    public WorldStorage getOrCreate(BlockPos pos, Level level) {
        WorldStorage storage = this.get(pos, level);
        if (storage != null) {
            return storage;
        }
        for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
            WorldStorageHandler handler;
            if (!(handlerMaybeWS instanceof WorldStorageHandler) || !Util.isValidBlocks(handler = (WorldStorageHandler)handlerMaybeWS, pos, level)) continue;
            storage = handler.getEmptyWorldStorage();
            this.storageMap.put(pos, storage);
            return storage;
        }
        storage = this.storageMap.get(pos);
        if (storage instanceof AnvilStorage) {
            AnvilStorage as = (AnvilStorage)storage;
            if (ImmersiveHandlers.smithingTableHandler.isValidBlock(pos, level)) {
                SmithingTableStorage sts = new SmithingTableStorage();
                sts.copyFromOld(as);
                sts.convertFrom119();
                this.storageMap.put(pos, sts);
                this.setDirty();
                return sts;
            }
        }
        return null;
    }

    public static void unmarkAllItemStoragesDirty(MinecraftServer server) {
        for (ServerLevel level : server.getAllLevels()) {
            ImmersiveMCLevelStorage storage = (ImmersiveMCLevelStorage)level.getDataStorage().get(factory, DATA_KEY);
            if (storage == null) continue;
            storage.storageMap.forEach((pos, ws) -> {
                if (ws instanceof ItemStorage) {
                    ItemStorage is = (ItemStorage)ws;
                    is.setNoLongerDirtyForClientSync();
                }
            });
        }
    }

    public static ImmersiveMCLevelStorage load(CompoundTag nbt, HolderLookup.Provider provider) {
        ImmersiveMCLevelStorage levelStorage = new ImmersiveMCLevelStorage();
        int lastVanillaDataVersion = nbt.contains("lastVanillaDataVersion") ? nbt.getInt("lastVanillaDataVersion") : Math.min(3700, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        nbt = ImmersiveMCLevelStorage.maybeUpgradeNBT(nbt, provider, lastVanillaDataVersion);
        Map<BlockPos, WorldStorage> storageMap = levelStorage.storageMap;
        storageMap.clear();
        int numOfStorages = nbt.getInt("numOfStorages");
        CompoundTag storages = nbt.getCompound("storages");
        for (int i = 0; i < numOfStorages; ++i) {
            CompoundTag storageInfo = storages.getCompound(String.valueOf(i));
            BlockPos pos = new BlockPos(storageInfo.getInt("posX"), storageInfo.getInt("posY"), storageInfo.getInt("posZ"));
            ResourceLocation id = Util.getResourceLocation(storageInfo, "id");
            WorldStorage storage = null;
            for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
                if (!handlerMaybeWS.getID().equals((Object)id) || !(handlerMaybeWS instanceof WorldStorageHandler)) continue;
                WorldStorageHandler handler = (WorldStorageHandler)handlerMaybeWS;
                storage = handler.getEmptyWorldStorage();
                storage.load(storageInfo.getCompound("data"), provider, lastVanillaDataVersion);
                break;
            }
            if (storage == null) continue;
            storageMap.put(pos, storage);
        }
        return levelStorage;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("lastVanillaDataVersion", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        nbt.putInt("version", 2);
        nbt.putInt("numOfStorages", this.storageMap.size());
        CompoundTag storages = new CompoundTag();
        int i = 0;
        for (Map.Entry<BlockPos, WorldStorage> entry : this.storageMap.entrySet()) {
            CompoundTag storageInfo = new CompoundTag();
            storageInfo.putInt("posX", entry.getKey().getX());
            storageInfo.putInt("posY", entry.getKey().getY());
            storageInfo.putInt("posZ", entry.getKey().getZ());
            storageInfo.put("data", (Tag)entry.getValue().save(new CompoundTag(), provider));
            Util.putResourceLocation(storageInfo, "id", entry.getValue().getHandler().getID());
            storages.put(String.valueOf(i), (Tag)storageInfo);
            ++i;
        }
        nbt.put("storages", (Tag)storages);
        return nbt;
    }

    private static CompoundTag maybeUpgradeNBT(CompoundTag nbtIn, HolderLookup.Provider provider, int lastVanillaDataVersion) {
        int version = 1;
        if (nbtIn.contains("version")) {
            version = nbtIn.getInt("version");
        }
        while (version < 2) {
            if (version == 1) {
                int numOfStorages = nbtIn.getInt("numOfStorages");
                CompoundTag storages = nbtIn.getCompound("storages");
                for (int i = 0; i < numOfStorages; ++i) {
                    ResourceLocation id;
                    CompoundTag storage = storages.getCompound(String.valueOf(i));
                    String oldDataType = storage.getString("dataType");
                    storage.remove("dataType");
                    CompoundTag itemsData = storage.getCompound("data");
                    String oldIdentifier = itemsData.getString("identifier");
                    itemsData.remove("identifier");
                    int numItems = itemsData.getInt("numOfItems");
                    if (numItems == 10) {
                        id = ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"crafting_table");
                    } else if (numItems == 4 || numItems == 3 && oldDataType.equals("basic_item_store")) {
                        id = ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"smithing_table");
                    } else if (numItems == 3) {
                        id = ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"anvil");
                    } else {
                        if (numItems != 1) continue;
                        ItemStack item = ServerUtil.parseItem(provider, itemsData.getCompound("item0"), lastVanillaDataVersion);
                        id = item.is(ItemTags.BEACON_PAYMENT_ITEMS) ? ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"beacon") : ResourceLocation.fromNamespaceAndPath((String)"immersivemc", (String)"enchanting_table");
                    }
                    Util.putResourceLocation(storage, "id", id);
                }
            }
            ++version;
        }
        return nbtIn;
    }
}

