/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.storage.world;

import com.hammy275.immersivemc.server.ServerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class ImmersiveMCPlayerStorages
extends SavedData {
    private static final int PLAYER_STORAGES_VERSION = 2;
    private static SavedData.Factory<ImmersiveMCPlayerStorages> factory = new SavedData.Factory(ImmersiveMCPlayerStorages::create, ImmersiveMCPlayerStorages::load, null);
    protected Map<UUID, List<ItemStack>> backpackCraftingItemsMap = new HashMap<UUID, List<ItemStack>>();
    protected Set<UUID> disabledPlayers = new HashSet<UUID>();

    private static ImmersiveMCPlayerStorages create() {
        return new ImmersiveMCPlayerStorages();
    }

    public static List<ItemStack> getBackpackCraftingStorage(Player player) {
        return ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).backpackCraftingItemsMap.computeIfAbsent(player.getUUID(), uuid -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i <= 4; ++i) {
                items.add(ItemStack.EMPTY);
            }
            return items;
        });
    }

    public static ImmersiveMCPlayerStorages getPlayerStorage(Player player) {
        if (!player.level().isClientSide) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            return (ImmersiveMCPlayerStorages)sPlayer.getServer().overworld().getDataStorage().computeIfAbsent(factory, "immersivemc_player_data");
        }
        throw new IllegalArgumentException("Can only access storage on server-side!");
    }

    public static boolean isPlayerDisabled(Player player) {
        return ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).disabledPlayers.contains(player.getUUID());
    }

    public static void setPlayerDisabled(Player player) {
        ImmersiveMCPlayerStorages storage = ImmersiveMCPlayerStorages.getPlayerStorage(player);
        storage.disabledPlayers.add(player.getUUID());
        storage.setDirty();
    }

    public static void setPlayerEnabled(Player player) {
        ImmersiveMCPlayerStorages storage = ImmersiveMCPlayerStorages.getPlayerStorage(player);
        storage.disabledPlayers.remove(player.getUUID());
        storage.setDirty();
    }

    public static ImmersiveMCPlayerStorages load(CompoundTag nbt, HolderLookup.Provider provider) {
        CompoundTag disabledPlayers;
        ImmersiveMCPlayerStorages playerStorage = new ImmersiveMCPlayerStorages();
        int lastVanillaDataVersion = nbt.contains("lastVanillaDataVersion") ? nbt.getInt("lastVanillaDataVersion") : Math.min(3700, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        nbt = ImmersiveMCPlayerStorages.maybeUpgradeNBT(nbt, lastVanillaDataVersion);
        Set keys = nbt.getAllKeys();
        for (String uuidStr : keys) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                CompoundTag bagItems = nbt.getCompound(uuidStr).getCompound("bagItems");
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 0; i <= 4; ++i) {
                    items.add(ServerUtil.parseItem(provider, bagItems.getCompound(String.valueOf(i)), lastVanillaDataVersion));
                }
                playerStorage.backpackCraftingItemsMap.put(uuid, items);
            }
            catch (IllegalArgumentException uuid) {}
        }
        CompoundTag compoundTag = disabledPlayers = nbt.contains("disabledPlayers") ? nbt.getCompound("disabledPlayers") : null;
        if (disabledPlayers != null) {
            for (String key : disabledPlayers.getAllKeys()) {
                if (!disabledPlayers.getString(key).equalsIgnoreCase("true")) continue;
                playerStorage.disabledPlayers.add(UUID.fromString(key));
            }
        }
        return playerStorage;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("lastVanillaDataVersion", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        nbt.putInt("version", 2);
        for (Map.Entry<UUID, List<ItemStack>> entry : this.backpackCraftingItemsMap.entrySet()) {
            CompoundTag playerData = new CompoundTag();
            CompoundTag bagData = new CompoundTag();
            List<ItemStack> items = entry.getValue();
            for (int i = 0; i <= 4; ++i) {
                Tag itemData = i >= items.size() ? ItemStack.EMPTY.saveOptional(provider) : items.get(i).saveOptional(provider);
                bagData.put(String.valueOf(i), itemData);
            }
            playerData.put("bagItems", (Tag)bagData);
            nbt.put(String.valueOf(entry.getKey()), (Tag)playerData);
        }
        CompoundTag disabledPlayers = new CompoundTag();
        for (UUID disabled : this.disabledPlayers) {
            disabledPlayers.putString(disabled.toString(), "true");
        }
        nbt.put("disabledPlayers", (Tag)disabledPlayers);
        return nbt;
    }

    private static CompoundTag maybeUpgradeNBT(CompoundTag nbtIn, int lastVanillaDataVersion) {
        int version = 1;
        if (nbtIn.contains("version")) {
            version = nbtIn.getInt("version");
        }
        while (version < 2) {
            if (version == 1) {
                CompoundTag newNBT = new CompoundTag();
                Set keys = nbtIn.getAllKeys();
                for (String uuidStr : keys) {
                    CompoundTag oldPlayerData = nbtIn.getCompound(uuidStr);
                    CompoundTag bagItems = oldPlayerData.getCompound("storages").getCompound("0").getCompound("data");
                    bagItems.remove("identifier");
                    bagItems.remove("numOfItems");
                    for (int i = 0; i <= 4; ++i) {
                        CompoundTag itemData = bagItems.getCompound("item" + i);
                        bagItems.remove("item" + i);
                        bagItems.put(String.valueOf(i), (Tag)itemData);
                    }
                    CompoundTag newPlayerData = new CompoundTag();
                    newPlayerData.put("bagItems", (Tag)bagItems);
                    newNBT.put(uuidStr, (Tag)newPlayerData);
                }
                nbtIn = newNBT;
            }
            ++version;
        }
        return nbtIn;
    }
}

