/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.swap;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.immersive.SwapMode;
import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.compat.apotheosis.Apoth;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.AnvilStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.SmithingTableStorage;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ETableStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.mixin.AnvilMenuMixin;
import com.hammy275.immersivemc.server.api_impl.SwapResultImpl;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import com.hammy275.immersivemc.server.storage.world.impl.ETableWorldStorage;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Swap {
    public static SwapResult swapItems(ItemStack handStack, ItemStack immersiveStack, ItemSwapAmount swapAmount, int forcedMaxImmersiveStackSize, Player player, @Nullable Consumer<Integer> itemCountIncrementer, @Nullable Consumer<Void> itemCountClearer) {
        ItemStack leftovers;
        ItemStack toHand;
        ItemStack toImmersive;
        boolean immersiveStackAtMax;
        int immersiveMaxStackSize = forcedMaxImmersiveStackSize == -1 ? handStack.getMaxStackSize() : forcedMaxImmersiveStackSize;
        int amountToPlace = Math.min(swapAmount.getNumItemsToSwap(), immersiveMaxStackSize);
        boolean handAndImmersiveStackMatch = Util.stacksEqualBesidesCount(handStack, immersiveStack);
        boolean bl = immersiveStackAtMax = immersiveStack.getCount() == immersiveMaxStackSize;
        if (handAndImmersiveStackMatch && !handStack.isEmpty() && !immersiveStackAtMax) {
            ItemStack handStackToPlace = handStack.copy();
            handStackToPlace.setCount(amountToPlace);
            int oldImmersiveCount = immersiveStack.getCount();
            Util.ItemStackMergeResult mergeResult = Util.mergeStacks(immersiveStack, handStackToPlace, false);
            toImmersive = immersiveStack;
            toHand = handStack.copy();
            toHand.shrink(amountToPlace);
            toHand.grow(mergeResult.mergedFrom.getCount());
            leftovers = ItemStack.EMPTY;
            int itemsMoved = immersiveStack.getCount() - oldImmersiveCount;
            if (itemCountIncrementer != null) {
                itemCountIncrementer.accept(itemsMoved);
            }
        } else if (handStack.isEmpty()) {
            boolean stackToInventory = Util.hasItemInInventoryWithStackSpace(player, immersiveStack);
            toHand = stackToInventory ? ItemStack.EMPTY : immersiveStack.copy();
            toImmersive = ItemStack.EMPTY;
            ItemStack itemStack = leftovers = stackToInventory ? immersiveStack.copy() : ItemStack.EMPTY;
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
        } else if (immersiveStackAtMax && handAndImmersiveStackMatch) {
            toHand = immersiveStack.copy();
            toImmersive = ItemStack.EMPTY;
            leftovers = handStack.copy();
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
        } else {
            toHand = handStack.copy();
            toHand.shrink(amountToPlace);
            toImmersive = handStack.copy();
            toImmersive.setCount(amountToPlace);
            leftovers = immersiveStack.copy();
            if (toHand.isEmpty() && !Util.hasItemInInventoryWithStackSpace(player, leftovers)) {
                toHand = leftovers;
                leftovers = ItemStack.EMPTY;
            }
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
            if (itemCountIncrementer != null) {
                itemCountIncrementer.accept(amountToPlace);
            }
        }
        return new SwapResultImpl(toHand, toImmersive, leftovers);
    }

    public static boolean doEnchanting(int slot, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        if (slot < 1 || slot > 3) {
            return false;
        }
        ETableWorldStorage storage = (ETableWorldStorage)WorldStoragesImpl.getOrCreateS(pos, player.serverLevel());
        ItemStack toEnchantItem = storage.getItem(0).copy();
        if (toEnchantItem.isEmpty()) {
            return false;
        }
        int lapisInInventory = 0;
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            if (player.getInventory().getItem(i).getItem() != Items.LAPIS_LAZULI) continue;
            lapisInInventory += player.getInventory().getItem(i).getCount();
        }
        if (lapisInInventory < slot && !player.getAbilities().instabuild) {
            return false;
        }
        if (player.experienceLevel < slot && !player.getAbilities().instabuild) {
            return false;
        }
        boolean doApoth = Apoth.apothImpl.enchantModuleEnabled();
        boolean takeLapis = false;
        if (doApoth) {
            ETableStorage.SlotData[] stats = Apoth.apothImpl.getEnchData((Player)player, pos, toEnchantItem);
            if (player.experienceLevel < stats[slot - 1].xpLevel() && !player.getAbilities().instabuild) {
                return false;
            }
            takeLapis = true;
            ItemStack out = Apoth.apothImpl.doEnchant((Player)player, pos, slot - 1, toEnchantItem);
            if (out == null) {
                out = toEnchantItem;
            }
            Util.giveStackHandFirst((Player)player, hand, out);
            storage.setItem(0, ItemStack.EMPTY);
        } else {
            EnchantmentMenu container = new EnchantmentMenu(-1, player.getInventory(), ContainerLevelAccess.create((Level)player.level(), (BlockPos)pos));
            container.setItem(1, 0, new ItemStack((ItemLike)Items.LAPIS_LAZULI, 64));
            container.setItem(0, 0, toEnchantItem);
            if (container.clickMenuButton((Player)player, slot - 1)) {
                takeLapis = true;
                Util.giveStackHandFirst((Player)player, hand, container.getSlot(0).getItem());
                storage.setItem(0, ItemStack.EMPTY);
            }
        }
        if (takeLapis) {
            int lapisToTake = slot;
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                if (player.getInventory().getItem(i).getItem() == Items.LAPIS_LAZULI) {
                    ItemStack stack = player.getInventory().getItem(i);
                    while (!stack.isEmpty() && lapisToTake > 0) {
                        stack.shrink(1);
                        --lapisToTake;
                    }
                }
                if (lapisToTake == 0) break;
            }
        }
        return takeLapis;
    }

    public static void handleBackpackCraftingSwap(int slot, InteractionHand hand, List<ItemStack> items, ServerPlayer player, ItemSwapAmount amount) {
        ItemStack[] itemArray = new ItemStack[5];
        for (int i = 0; i <= 4; ++i) {
            itemArray[i] = items.get(i);
        }
        if (slot < 4) {
            ItemStack playerItem = player.getItemInHand(hand);
            ItemStack tableItem = itemArray[slot];
            SwapResult result = ImmersiveLogicHelpers.instance().swapItems(playerItem, tableItem, amount, (Player)player);
            itemArray[slot] = result.immersiveStack();
            result.giveToPlayer((Player)player, hand);
            itemArray[4] = Swap.getRecipeOutput(player, itemArray);
        } else if ((itemArray = Swap.handleDoCraft(player, itemArray, null, amount)) == null) {
            return;
        }
        for (int i = 0; i <= 4; ++i) {
            items.set(i, itemArray[i]);
        }
        ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).setDirty();
    }

    public static boolean handleAnvilCraft(AnvilStorage storage, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        ItemStack mid;
        ItemStack left = storage.getItem(0);
        Pair<ItemStack, Integer> resAndCost = Swap.getAnvilOutput(left, mid = storage.getItem(1), player);
        if ((player.experienceLevel >= (Integer)resAndCost.getSecond() || player.getAbilities().instabuild) && !((ItemStack)resAndCost.getFirst()).isEmpty()) {
            AnvilMenu container = new AnvilMenu(-1, player.getInventory(), ContainerLevelAccess.create((Level)player.level(), (BlockPos)pos));
            container.getSlot(2).onTake((Player)player, (ItemStack)resAndCost.getFirst());
            if (!player.getAbilities().instabuild) {
                player.giveExperienceLevels(-((Integer)resAndCost.getSecond()).intValue());
            }
            storage.setItem(0, container.getSlot(0).getItem().copy());
            storage.setItem(1, container.getSlot(1).getItem().copy());
            Pair<ItemStack, Integer> output = Swap.getAnvilOutput(storage.getItem(0), storage.getItem(1), player);
            storage.setItem(2, (ItemStack)output.getFirst());
            storage.xpLevels = (Integer)output.getSecond();
            Util.giveStackHandFirst((Player)player, hand, (ItemStack)resAndCost.getFirst());
            return true;
        }
        return false;
    }

    public static boolean handleSmithingTableCraft(SmithingTableStorage storage, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        ItemStack right;
        ItemStack mid;
        ItemStack left = storage.getItem(0);
        ItemStack output = Swap.getSmithingTableOutput(left, mid = storage.getItem(1), right = storage.getItem(2), player);
        if (!output.isEmpty()) {
            SmithingMenu container = new SmithingMenu(-1, player.getInventory(), ContainerLevelAccess.create((Level)player.level(), (BlockPos)pos));
            container.getSlot(3).onTake((Player)player, output);
            storage.shrinkSlot(0, 1);
            storage.shrinkSlot(1, 1);
            storage.shrinkSlot(2, 1);
            storage.setItem(3, ItemStack.EMPTY);
            Util.giveStackHandFirst((Player)player, hand, output);
            return true;
        }
        return false;
    }

    public static ItemStack getRecipeOutput(ServerPlayer player, ItemStack[] stacksIn) {
        int invDim = stacksIn.length >= 9 ? 3 : 2;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Arrays.asList(stacksIn).subList(0, invDim * invDim));
        CraftingInput inv = CraftingInput.of((int)invDim, (int)invDim, stacks);
        Optional res = player.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)inv, player.level());
        if (res.isPresent()) {
            return ((CraftingRecipe)((RecipeHolder)res.get()).value()).assemble((RecipeInput)inv, (HolderLookup.Provider)player.level().registryAccess());
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public static ItemStack[] handleDoCraft(ServerPlayer player, ItemStack[] stacksIn, BlockPos tablePos, ItemSwapAmount amount) {
        int i;
        int iters;
        ItemStack stackOut;
        boolean isBackpack = stacksIn.length == 5;
        InventoryMenu menu = isBackpack ? new InventoryMenu(player.getInventory(), false, (Player)player) : new CraftingMenu(-1, player.getInventory());
        ItemStack firstOut = stackOut = Swap.getRecipeOutput(player, stacksIn);
        ItemStack[] newSlotsState = Arrays.copyOf(stacksIn, stacksIn.length);
        ArrayList<ItemStack> stacksToGive = new ArrayList<ItemStack>();
        int itersDone = 0;
        int n = iters = amount.getSwapMode() == SwapMode.ALL ? Integer.MAX_VALUE : amount.getNumItemsToSwap();
        while (itersDone++ < iters && ItemStack.matches((ItemStack)firstOut, (ItemStack)stackOut) && !stackOut.isEmpty() && Swap.itemStackArraysMatchBesidesCount(stacksIn, newSlotsState, isBackpack ? 4 : 9)) {
            for (i = 0; i < newSlotsState.length - 1; ++i) {
                menu.setItem(i + 1, 0, newSlotsState[i].copy());
            }
            menu.getSlot(0).set(stackOut);
            menu.getSlot(0).onTake((Player)player, stackOut);
            stackOut.onCraftedBy(player.level(), (Player)player, stackOut.getCount());
            for (i = 0; i < newSlotsState.length - 1; ++i) {
                newSlotsState[i] = menu.getSlot(i + 1).getItem();
            }
            stacksToGive.add(stackOut);
            newSlotsState[newSlotsState.length - 1] = stackOut = Swap.getRecipeOutput(player, newSlotsState);
        }
        if (isBackpack) {
            menu.setItem(0, 0, ItemStack.EMPTY);
            for (i = 1; i < 5; ++i) {
                menu.setItem(i, 0, ItemStack.EMPTY);
            }
        }
        if (stacksToGive.isEmpty()) {
            return null;
        }
        boolean playedSound = false;
        for (ItemStack toGive : stacksToGive) {
            ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!handStack.isEmpty() && Util.stacksEqualBesidesCount(toGive, handStack)) {
                Util.ItemStackMergeResult itemRes = Util.mergeStacks(handStack, toGive, true);
                player.setItemInHand(InteractionHand.MAIN_HAND, itemRes.mergedInto);
                toGive = itemRes.mergedFrom;
            } else if (handStack.isEmpty() && !Util.hasItemInInventoryWithStackSpace((Player)player, toGive)) {
                player.setItemInHand(InteractionHand.MAIN_HAND, toGive);
                toGive = ItemStack.EMPTY;
            }
            if (!toGive.isEmpty()) {
                BlockPos posBlock = tablePos != null ? tablePos.above() : player.blockPosition();
                Vec3 pos = Vec3.atCenterOf((Vec3i)posBlock);
                ItemEntity entOut = new ItemEntity(player.level(), pos.x, pos.y, pos.z, toGive);
                entOut.setDeltaMovement(0.0, 0.0, 0.0);
                player.level().addFreshEntity((Entity)entOut);
                continue;
            }
            if (playedSound) continue;
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, isBackpack ? SoundSource.PLAYERS : SoundSource.BLOCKS, 0.2f, ThreadLocalRandom.current().nextFloat() - ThreadLocalRandom.current().nextFloat() * 1.4f + 2.0f);
            playedSound = true;
        }
        return newSlotsState;
    }

    public static void handleInventorySwap(Player player, int slot, InteractionHand hand) {
        ItemStack handStack = player.getItemInHand(hand).copy();
        ItemStack invStack = player.getInventory().getItem(slot).copy();
        if (handStack.isEmpty() || invStack.isEmpty() || !Util.stacksEqualBesidesCount(handStack, invStack)) {
            player.setItemInHand(hand, invStack);
            player.getInventory().setItem(slot, handStack);
        } else {
            Util.ItemStackMergeResult res = Util.mergeStacks(invStack, handStack, false);
            player.setItemInHand(hand, res.mergedFrom);
            player.getInventory().setItem(slot, res.mergedInto);
        }
    }

    public static void handleChest(ChestBlockEntity chestIn, ServerPlayer player, InteractionHand hand, int slot) {
        Container chest;
        ChestBlockEntity chestBlockEntity = chestIn = slot > 26 ? Util.getOtherChest(chestIn) : chestIn;
        if (chestIn == null) {
            return;
        }
        Container lootrChest = Lootr.lootrImpl.getContainer(player, chestIn.getBlockPos());
        Object object = chest = lootrChest != null ? lootrChest : chestIn;
        if (chest != null) {
            ItemStack chestItem = chest.getItem(slot %= 27).copy();
            ItemStack playerItem = player.getItemInHand(hand);
            if (playerItem.isEmpty() || chestItem.isEmpty() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
                player.setItemInHand(hand, chestItem);
                chest.setItem(slot, playerItem);
            } else {
                Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
                player.setItemInHand(hand, result.mergedFrom);
                chest.setItem(slot, result.mergedInto);
            }
            chest.setChanged();
        }
    }

    public static void handleEnderChest(Player player, InteractionHand hand, int slot) {
        ItemStack chestItem = player.getEnderChestInventory().getItem(slot).copy();
        ItemStack playerItem = player.getItemInHand(hand);
        if (playerItem.isEmpty() || chestItem.isEmpty() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
            player.setItemInHand(hand, chestItem);
            player.getEnderChestInventory().setItem(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
            player.setItemInHand(hand, result.mergedFrom);
            player.getEnderChestInventory().setItem(slot, result.mergedInto);
        }
    }

    public static Pair<ItemStack, Integer> getAnvilOutput(ItemStack left, ItemStack mid, ServerPlayer player) {
        AnvilMenu container = new AnvilMenu(-1, player.getInventory());
        container.setItem(0, 0, left);
        container.setItem(1, 0, mid);
        container.createResult();
        ItemStack res = container.getSlot(2).getItem();
        int level = ((AnvilMenuMixin)container).immersiveMC$getCost().get();
        return new Pair((Object)res, (Object)level);
    }

    public static ItemStack getSmithingTableOutput(ItemStack left, ItemStack mid, ItemStack right, ServerPlayer player) {
        SmithingMenu container = new SmithingMenu(-1, player.getInventory());
        container.setItem(0, 0, left);
        container.setItem(1, 0, mid);
        container.setItem(2, 0, right);
        container.createResult();
        ItemStack res = container.getSlot(3).getItem();
        return res;
    }

    public static boolean itemStackArraysMatchBesidesCount(ItemStack[] a, ItemStack[] b, int numElements) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < numElements; ++i) {
            ItemStack as = a[i];
            ItemStack bs = b[i];
            if (as == bs || as != null && bs != null && Util.stacksEqualBesidesCount(as, bs)) continue;
            return false;
        }
        return true;
    }
}

