/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.hammy275.immersivemc.mixin.ButtonBlockMixin;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ButtonPushTracker
extends AbstractTracker {
    public ButtonPushTracker() {
        ServerTrackerInit.playerTrackers.add(this);
    }

    @Override
    protected void tick(Player player) {
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        for (int i = 0; i <= 1; ++i) {
            IVRData controller = vrPlayer.getController(i);
            BlockPos pos = BlockPos.containing((Position)controller.position());
            BlockState state = player.level().getBlockState(pos);
            if (!(state.getBlock() instanceof ButtonBlock) || ((Boolean)state.getValue((Property)ButtonBlock.POWERED)).booleanValue()) continue;
            ButtonBlock button = (ButtonBlock)state.getBlock();
            VoxelShape shape = state.getShape((BlockGetter)player.level(), pos, CollisionContext.of((Entity)player));
            BlockHitResult res = shape.clip(controller.position().add(0.0, -0.01, 0.0), controller.position().add(0.0, 0.01, 0.0), pos);
            if (res == null || !res.getBlockPos().equals((Object)pos)) continue;
            button.press(state, player.level(), pos, null);
            ((ButtonBlockMixin)button).immersiveMC$playButtonSound(null, (LevelAccessor)player.level(), pos, true);
            VRRumble.rumbleIfVR(player, i, 0.15f);
        }
    }

    @Override
    protected boolean shouldTick(Player player) {
        return ActiveConfig.FILE_SERVER.useButtonImmersive && VRPluginVerify.hasAPI && VRPlugin.API.playerInVR(player) && VRPlugin.API.apiActive(player) && ActiveConfig.getConfigForPlayer((Player)player).useButtonImmersive;
    }
}

